/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.condition;

import com.sigmundgranaas.forgero.core.condition.ConditionContainer;
import com.sigmundgranaas.forgero.core.condition.NamedCondition;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface Conditional<T extends PropertyContainer> {
    public static final ConditionContainer EMPTY = new ConditionContainer();

    public static List<PropertyContainer> removeConditions(List<PropertyContainer> conditions, String name) {
        return conditions.stream().filter(condition -> Conditional.filterAwayCondition(condition, name)).toList();
    }

    public static boolean filterAwayCondition(PropertyContainer condition, String name) {
        if (condition instanceof NamedCondition) {
            NamedCondition namedCondition = (NamedCondition)condition;
            return !name.equals(namedCondition.name());
        }
        return true;
    }

    public List<PropertyContainer> localConditions();

    default public List<PropertyContainer> compoundedConditions() {
        return this.localConditions();
    }

    public T applyCondition(PropertyContainer var1);

    public T removeCondition(String var1);

    @NotNull
    default public List<Property> conditionProperties(Matchable matchable, MatchContext context) {
        return this.localConditions().stream().map(props -> props.getRootProperties(matchable, context)).flatMap(Collection::stream).toList();
    }

    @NotNull
    default public List<NamedCondition> namedConditions(List<PropertyContainer> conditions) {
        return conditions.stream().filter(NamedCondition.class::isInstance).map(NamedCondition.class::cast).toList();
    }
}

