/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfiguration;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class ForgeroConfigurationLoader {
    public static final ForgeroConfiguration defaultConfiguration = new ForgeroConfiguration();
    public static String configurationFileName = "forgero_settings.json";
    public static Path configurationFolderPath;
    public static Path configurationFilePath;
    public static boolean havePathsBeenResolved;
    public static ForgeroConfiguration configuration;

    public static ForgeroConfiguration load(Path configDir) {
        ForgeroConfiguration forgeroConfiguration;
        block10: {
            configurationFolderPath = configDir;
            configurationFilePath = configurationFolderPath.resolve(configurationFileName);
            havePathsBeenResolved = true;
            if (!Files.exists(configurationFilePath, new LinkOption[0])) {
                configuration = ForgeroConfigurationLoader.createConfigurationFile();
                return configuration;
            }
            InputStream stream = Files.newInputStream(configurationFilePath, new OpenOption[0]);
            try {
                Gson gson = ForgeroConfigurationLoader.createGson();
                configuration = (ForgeroConfiguration)gson.fromJson(new JsonReader((Reader)new BufferedReader(new InputStreamReader(stream))), ForgeroConfiguration.class);
                ForgeroConfigurationLoader.save();
                if (ForgeroConfigurationLoader.configuration.resourceLogging.booleanValue()) {
                    Forgero.LOGGER.info("Loaded Forgero configuration, located at: {}", (Object)configurationFilePath);
                }
                forgeroConfiguration = configuration;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Forgero.LOGGER.warn("Unable to read Forgero configuration file, located at {}. Loading default configuration. Check if the formatting is correct. See stack trace below:", (Object)configurationFilePath);
                    e.printStackTrace();
                    configuration = defaultConfiguration;
                    return defaultConfiguration;
                }
            }
            stream.close();
        }
        return forgeroConfiguration;
    }

    public static void save() {
        if (!havePathsBeenResolved) {
            Forgero.LOGGER.warn("Unable to save Forgero configuration file, configuration file path hasn't been resolved yet. ForgeroConfigurationLoader#load should be called before ForgeroConfigurationLoader#save.");
            return;
        }
        try (FileWriter writer = new FileWriter(configurationFilePath.toString());){
            Gson gson = ForgeroConfigurationLoader.createGson();
            String json = gson.toJson((Object)configuration);
            writer.write(json);
        }
        catch (IOException e) {
            Forgero.LOGGER.warn("Unable to save Forgero configuration file, located at {}. See stack trace below:", (Object)configurationFilePath);
            e.printStackTrace();
        }
    }

    @NotNull
    private static Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        return gsonBuilder.setPrettyPrinting().create();
    }

    private static ForgeroConfiguration createConfigurationFile() {
        ForgeroConfiguration forgeroConfiguration;
        if (!havePathsBeenResolved) {
            Forgero.LOGGER.warn("Unable to create Forgero configuration file, configuration file path hasn't been resolved yet. ForgeroConfigurationLoader#load should be called before ForgeroConfigurationLoader#createConfigurationFile.");
            return defaultConfiguration;
        }
        if (!configurationFolderPath.toFile().exists()) {
            Forgero.LOGGER.warn("Unable to create Forgero configuration file at {}. Configuration folder (/config) doesn't exist. Loading default configuration.", (Object)configurationFilePath);
            return defaultConfiguration;
        }
        FileWriter writer = new FileWriter(configurationFilePath.toString());
        try {
            Gson gson = ForgeroConfigurationLoader.createGson();
            String json = gson.toJson((Object)defaultConfiguration);
            writer.write(json);
            Forgero.LOGGER.info("Created Forgero configuration file, located at {}", (Object)configurationFilePath);
            forgeroConfiguration = defaultConfiguration;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Forgero.LOGGER.warn("Unable to create Forgero configuration file at {}. Loading default configuration. See stack trace below:", (Object)configurationFilePath);
                e.printStackTrace();
                return defaultConfiguration;
            }
        }
        writer.close();
        return forgeroConfiguration;
    }

    static {
        havePathsBeenResolved = false;
        configuration = defaultConfiguration;
    }
}

