/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.customdata;

import com.sigmundgranaas.forgero.core.customdata.CustomJsonDataContainer;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.customdata.DataVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ClassBasedVisitor<T>
implements DataVisitor<T> {
    private final Class<T> type;
    private final String key;

    public ClassBasedVisitor(Class<T> type, String key) {
        this.type = type;
        this.key = key;
    }

    @Override
    public Optional<T> visit(DataContainer dataContainer) {
        if (dataContainer instanceof CustomJsonDataContainer) {
            CustomJsonDataContainer customJsonDataContainer = (CustomJsonDataContainer)dataContainer;
            return customJsonDataContainer.getObject(this.key(), this.type);
        }
        return this.visitMultiple(dataContainer).stream().findFirst();
    }

    @Override
    public List<T> visitMultiple(DataContainer dataContainer) {
        if (dataContainer instanceof CustomJsonDataContainer) {
            CustomJsonDataContainer customJsonDataContainer = (CustomJsonDataContainer)dataContainer;
            List<T> results = customJsonDataContainer.getObjectList(this.key(), this.type);
            if (results.isEmpty()) {
                this.visit(dataContainer).ifPresent(results::add);
            }
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    public String key() {
        return this.key;
    }
}

