/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.customdata;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sigmundgranaas.forgero.core.customdata.Context;
import com.sigmundgranaas.forgero.core.customdata.ContextAwareData;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.customdata.TargetData;
import com.sigmundgranaas.forgero.core.property.Target;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomJsonDataContainer
implements DataContainer {
    @NotNull
    private final Map<String, JsonElement> customData;

    public CustomJsonDataContainer(@NotNull Map<String, JsonElement> customData) {
        this.customData = customData;
    }

    public static DataContainer of(@Nullable Map<String, JsonElement> customData) {
        if (customData == null || customData.isEmpty()) {
            return DataContainer.empty();
        }
        return new CustomJsonDataContainer(customData);
    }

    @Override
    public Optional<Integer> getInteger(String key) {
        return this.simpleValues(key, Integer.class);
    }

    @Override
    public Optional<Float> getFloat(String key) {
        return this.simpleValues(key, Float.class);
    }

    @Override
    public Optional<String> getString(String key) {
        return this.simpleValues(key, String.class);
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        return this.simpleValues(key, Boolean.class);
    }

    private <T> Optional<T> simpleValues(String key, Class<T> type) {
        Optional<T> element = this.getObject(key, type);
        if (element.isPresent()) {
            return element;
        }
        return this.contextValue(key, type).map(ContextAwareData::value);
    }

    private <T> Optional<ContextAwareData<T>> contextValue(String key, Class<T> type) {
        Optional<ContextAwareData> dataOptional = this.getObject(key, ContextAwareData.class);
        if (dataOptional.isPresent()) {
            ContextAwareData data = dataOptional.get();
            Optional<ContextAwareData<T>> converted = this.convertFromJsonElement(new Gson().toJsonTree(data.value()), type).map(value -> new ContextAwareData<Object>(data.context(), value));
            if (converted.isEmpty()) {
                JsonElement element;
                if (this.customData.containsKey(key) && (element = this.customData.get(key)).isJsonObject() && element.getAsJsonObject().has("context")) {
                    String context = element.getAsJsonObject().get("context").getAsString();
                    return Optional.of(new ContextAwareData<Object>(Context.valueOf(context), null));
                }
                return converted;
            }
            return converted;
        }
        return Optional.empty();
    }

    public <T> Optional<T> getObject(String key, Class<T> type) {
        Optional<JsonElement> element = Optional.ofNullable(this.getCustomData().get(key));
        if (element.isEmpty()) {
            return Optional.empty();
        }
        return this.convertFromJsonElement(element.get(), type).or(() -> this.getObjectList(key, type).stream().findFirst());
    }

    public <T> List<T> getObjectList(String key, Class<T> type) {
        Type token = TypeToken.getParameterized(List.class, (Type[])new Type[]{type}).getType();
        JsonElement element = this.getCustomData().get(key);
        if (element == null || element.isJsonNull()) {
            return Collections.emptyList();
        }
        Optional typedList = this.getTypedList(element, type, token);
        return typedList.orElse(Collections.emptyList());
    }

    private <T> Optional<List<T>> getTypedList(JsonElement element, Class<T> type, Type token) {
        T t;
        Optional<T> obj = this.convertFromJsonElement(element, token);
        if (obj.isPresent() && (t = obj.get()) instanceof List) {
            List list = (List)t;
            if (list.stream().allMatch(type::isInstance)) {
                List typedList = list;
                return Optional.of(typedList);
            }
        }
        return Optional.empty();
    }

    private <T> Optional<T> convertFromJsonElement(JsonElement element, Class<T> type) {
        try {
            return Optional.ofNullable(new Gson().fromJson(element, type));
        }
        catch (JsonSyntaxException e) {
            return Optional.empty();
        }
    }

    private <T> Optional<T> convertFromJsonElement(JsonElement element, Type type) {
        try {
            return Optional.ofNullable(new Gson().fromJson(element, type));
        }
        catch (JsonSyntaxException e) {
            return Optional.empty();
        }
    }

    @Override
    public CustomJsonDataContainer merge(DataContainer other) {
        if (other instanceof CustomJsonDataContainer) {
            CustomJsonDataContainer customJsonDataContainer = (CustomJsonDataContainer)other;
            HashMap<String, JsonElement> combinedMap = new HashMap<String, JsonElement>(this.getCustomData());
            for (Map.Entry<String, JsonElement> entry : customJsonDataContainer.getCustomData().entrySet()) {
                if (combinedMap.containsKey(entry.getKey())) {
                    combinedMap.put(entry.getKey(), this.mergeAsList((JsonElement)combinedMap.get(entry.getKey()), entry.getValue()));
                    continue;
                }
                combinedMap.put(entry.getKey(), entry.getValue());
            }
            return new CustomJsonDataContainer(combinedMap);
        }
        return this;
    }

    @Override
    public DataContainer merge(DataContainer other, Context context, Target target) {
        Map filteredValues = (Map)this.merge(other).getCustomData().entrySet().stream().filter(entry -> this.isRightContext((Map.Entry<String, JsonElement>)entry, context)).filter(entry -> this.isRightTarget((Map.Entry<String, JsonElement>)entry, target)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return new CustomJsonDataContainer(filteredValues);
    }

    private JsonElement mergeAsList(JsonElement a, JsonElement b) {
        if (a.isJsonArray() && b.isJsonArray()) {
            JsonArray aArray = a.getAsJsonArray();
            JsonArray bArray = b.getAsJsonArray();
            aArray.addAll(bArray);
            return aArray;
        }
        if (a.isJsonArray()) {
            JsonArray aArray = a.getAsJsonArray();
            aArray.add(b);
            return aArray;
        }
        if (b.isJsonArray()) {
            JsonArray bArray = b.getAsJsonArray();
            bArray.add(a);
            return bArray;
        }
        JsonArray newArray = new JsonArray();
        newArray.add(a);
        newArray.add(b);
        return newArray;
    }

    private boolean isRightContext(Map.Entry<String, JsonElement> entry, Context context) {
        Optional<ContextAwareData<Object>> convertedValue = this.contextValue(entry.getKey(), Object.class);
        return convertedValue.map(objectContextAwareData -> objectContextAwareData.context() == context).orElse(true);
    }

    private boolean isRightTarget(Map.Entry<String, JsonElement> entry, Target target) {
        Optional<TargetData> data = this.convertFromJsonElement(entry.getValue(), TargetData.class);
        return data.map(targetData -> targetData.isApplicable(target)).orElse(true);
    }

    @NotNull
    protected Map<String, JsonElement> getCustomData() {
        return this.customData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomJsonDataContainer that = (CustomJsonDataContainer)o;
        return Objects.equals(this.customData, that.customData);
    }

    public int hashCode() {
        return Objects.hash(this.customData);
    }
}

