/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.customdata;

import com.google.common.base.Enums;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.sigmundgranaas.forgero.core.property.Target;
import com.sigmundgranaas.forgero.core.property.TargetTypes;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TargetData {
    private final Set<String> targets;

    public TargetData(Set<String> targets) {
        this.targets = targets;
    }

    public static TargetData of(Set<String> targets) {
        return new TargetData(targets);
    }

    public static TargetData of() {
        return new TargetData(Collections.emptySet());
    }

    public static TargetData of(JsonElement element) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            Set<String> targets = IntStream.range(0, array.size()).mapToObj(i -> array.getAsString()).collect(Collectors.toSet());
            return new TargetData(targets);
        }
        if (element.isJsonObject() && element.getAsJsonObject().has("targets")) {
            return TargetData.of(element.getAsJsonObject().get("targets"));
        }
        return new TargetData(Collections.emptySet());
    }

    public boolean isApplicable(Target target) {
        if (this.targets == null || this.targets.isEmpty()) {
            return true;
        }
        return this.targets.stream().filter(this::isValid).anyMatch(id -> this.type((String)id).isPresent() && target.isApplicable(Set.of(this.strip((String)id)), this.type((String)id).get()));
    }

    public String strip(String target) {
        return target.split(":")[1];
    }

    public Optional<TargetTypes> type(String target) {
        Optional optionalType = Enums.getIfPresent(TargetTypes.class, (String)target.split(":")[0]).toJavaUtil();
        return optionalType.or(() -> Enums.getIfPresent(TargetTypes.class, (String)target.split(":")[0].toUpperCase()).toJavaUtil());
    }

    public boolean isValid(String target) {
        return target.split(":").length == 2 && this.type(target).isPresent();
    }
}

