/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.customdata.handler;

import com.google.gson.annotations.SerializedName;
import com.sigmundgranaas.forgero.core.customdata.ClassBasedVisitor;
import com.sigmundgranaas.forgero.core.customdata.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class LootVisitor
extends ClassBasedVisitor<CustomLootData> {
    public static final String KEY = "loot";

    public LootVisitor() {
        super(CustomLootData.class, KEY);
    }

    public static class CustomLootData {
        Context context = Context.LOCAL;
        @SerializedName(value="excluded_loot_tables", alternate={"excludedLootTables", "excluded"})
        Set<String> excludedLootTables = Collections.emptySet();
        Set<String> onlyLootTables = Collections.emptySet();

        public boolean isExcluded(String lootTable) {
            if (this.onlyLootTables.isEmpty()) {
                if (this.excludedLootTables.isEmpty()) {
                    return false;
                }
                return this.excludedLootTables.contains(lootTable);
            }
            return !this.onlyLootTables.contains(lootTable);
        }

        public boolean isExcluded(Collection<String> lootTables) {
            return lootTables.stream().anyMatch(this::isExcluded);
        }

        public Context context() {
            return this.context;
        }

        public Set<String> excludedLootTables() {
            return this.excludedLootTables;
        }

        public Set<String> onlyLootTables() {
            return this.onlyLootTables;
        }

        public CustomLootData context(Context context) {
            this.context = context;
            return this;
        }

        public CustomLootData excludedLootTables(Set<String> excludedLootTables) {
            this.excludedLootTables = excludedLootTables;
            return this;
        }

        public CustomLootData onlyLootTables(Set<String> onlyLootTables) {
            this.onlyLootTables = onlyLootTables;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomLootData)) {
                return false;
            }
            CustomLootData other = (CustomLootData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Context this$context = this.context();
            Context other$context = other.context();
            if (this$context == null ? other$context != null : !((Object)((Object)this$context)).equals((Object)other$context)) {
                return false;
            }
            Set<String> this$excludedLootTables = this.excludedLootTables();
            Set<String> other$excludedLootTables = other.excludedLootTables();
            if (this$excludedLootTables == null ? other$excludedLootTables != null : !((Object)this$excludedLootTables).equals(other$excludedLootTables)) {
                return false;
            }
            Set<String> this$onlyLootTables = this.onlyLootTables();
            Set<String> other$onlyLootTables = other.onlyLootTables();
            return !(this$onlyLootTables == null ? other$onlyLootTables != null : !((Object)this$onlyLootTables).equals(other$onlyLootTables));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomLootData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Context $context = this.context();
            result = result * 59 + ($context == null ? 43 : ((Object)((Object)$context)).hashCode());
            Set<String> $excludedLootTables = this.excludedLootTables();
            result = result * 59 + ($excludedLootTables == null ? 43 : ((Object)$excludedLootTables).hashCode());
            Set<String> $onlyLootTables = this.onlyLootTables();
            result = result * 59 + ($onlyLootTables == null ? 43 : ((Object)$onlyLootTables).hashCode());
            return result;
        }

        public String toString() {
            return "LootVisitor.CustomLootData(context=" + this.context() + ", excludedLootTables=" + this.excludedLootTables() + ", onlyLootTables=" + this.onlyLootTables() + ")";
        }
    }
}

