/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.handler;

import com.mojang.serialization.Codec;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HandlerBuilderRegistry {
    private static final Map<ClassKey<?>, Map<String, JsonBuilder<?>>> REGISTRY = new ConcurrentHashMap();
    private static final Map<ClassKey<?>, Map<String, Codec<?>>> CODEC_REGISTRY = new ConcurrentHashMap();

    public static <T> void register(ClassKey<T> type, String key, JsonBuilder<? extends T> builder) {
        REGISTRY.computeIfAbsent(type, k -> new ConcurrentHashMap()).put(key, builder);
    }

    public static <T> void register(ClassKey<T> type, String key, Codec<? extends T> builder) {
        CODEC_REGISTRY.computeIfAbsent(type, k -> new ConcurrentHashMap()).put(key, builder);
    }

    public static <T> RegisterBuilder<T> builder(String key, JsonBuilder<T> builder) {
        return new RegisterBuilder<T>(key, builder);
    }

    private static <R, T> Optional<JsonBuilder<T>> safeCast(JsonBuilder<? extends R> builder, ClassKey<T> type) {
        try {
            if (type.clazz().isAssignableFrom(builder.getTargetClass())) {
                return Optional.of(builder);
            }
        }
        catch (ClassCastException ignored) {
            Forgero.LOGGER.error("Could not cast builder to type: " + type.clazz().type().getTypeName());
        }
        return Optional.empty();
    }

    private <T> Optional<? extends Codec<T>> safeCast(Codec<?> builder, ClassKey<T> type) {
        try {
            return Optional.of(builder);
        }
        catch (ClassCastException ignored) {
            Forgero.LOGGER.error("Could not cast builder to type: " + type.clazz().type().getTypeName());
            return Optional.empty();
        }
    }

    public <T> Optional<JsonBuilder<T>> get(ClassKey<T> type, String key) {
        return Optional.ofNullable(REGISTRY.get(type)).flatMap(map -> Optional.ofNullable((JsonBuilder)map.get(key))).flatMap(builder -> HandlerBuilderRegistry.safeCast(builder, type));
    }

    public <T> Optional<Codec<T>> getCodec(ClassKey<T> type, String key) {
        return Optional.ofNullable(CODEC_REGISTRY.get(type)).flatMap(map -> Optional.ofNullable((Codec)map.get(key))).flatMap(builder -> this.safeCast((Codec<?>)builder, type));
    }

    public Set<String> entriesForKey(ClassKey<?> type) {
        return Stream.concat(REGISTRY.computeIfAbsent(type, key -> new HashMap()).keySet().stream(), CODEC_REGISTRY.computeIfAbsent(type, key -> new HashMap()).keySet().stream()).collect(Collectors.toSet());
    }

    public <T> List<JsonBuilder<T>> allJsonBuilders(ClassKey<T> type) {
        return REGISTRY.computeIfAbsent(type, key -> new HashMap()).values().stream().map(builder -> HandlerBuilderRegistry.safeCast(builder, type)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public record RegisterBuilder<R>(String key, JsonBuilder<? extends R> builder) {
        public <T> RegisterBuilder<R> register(ClassKey<T> type) {
            if (type.clazz().isAssignableFrom(this.builder.getTargetClass())) {
                HandlerBuilderRegistry.safeCast(this.builder, type).ifPresent(tJsonBuilder -> HandlerBuilderRegistry.register(type, this.key, tJsonBuilder));
            }
            return this;
        }
    }
}

