/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model;

import com.sigmundgranaas.forgero.core.model.CompositeModelTemplate;
import com.sigmundgranaas.forgero.core.model.ModelMatchEntry;
import com.sigmundgranaas.forgero.core.model.ModelMatcher;
import com.sigmundgranaas.forgero.core.model.ModelProvider;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.model.PaletteTemplateModel;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.Constructed;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class CompositeModelEntry
implements ModelMatcher {
    public static Optional<ModelTemplate> findUpgradeModel(Slot upgradeSlot, Composite construct, MatchContext context, ModelProvider provider) {
        if (upgradeSlot.filled()) {
            State state = upgradeSlot.get().get();
            if (state instanceof Composite) {
                Composite upgradeConstruct = (Composite)state;
                return provider.find(upgradeConstruct).filter(matcher -> matcher.match(upgradeConstruct, context)).flatMap(matcher -> matcher.get(upgradeConstruct, provider, context));
            }
            if (upgradeSlot.get().get().type().test(Type.PART)) {
                return provider.find(upgradeSlot.get().get()).filter(matcher -> matcher.match(upgradeSlot.get().get(), context)).flatMap(matcher -> matcher.get(upgradeSlot.get().get(), provider, context));
            }
            return provider.find(construct).filter(matcher -> matcher.match(upgradeSlot, context)).flatMap(matcher -> matcher.get(upgradeSlot, provider, context));
        }
        return Optional.empty();
    }

    @Override
    public boolean match(Matchable state, MatchContext context) {
        return state instanceof Composite;
    }

    @Override
    public Optional<ModelTemplate> get(Matchable state, ModelProvider provider, MatchContext context) {
        if (state instanceof Composite) {
            Composite composite = (Composite)state;
            CompositeModelTemplate compositeModelTemplate = new CompositeModelTemplate();
            context.add(composite.type()).add(new NameMatch(composite.name()));
            if (composite instanceof Constructed) {
                Constructed construct = (Constructed)((Object)composite);
                construct.parts().stream().map(stateEntry -> this.convert((State)stateEntry, provider, context)).flatMap(Optional::stream).forEach(compositeModelTemplate::add);
                List<PaletteTemplateModel> models = compositeModelTemplate.getModels().stream().filter(PaletteTemplateModel.class::isInstance).map(PaletteTemplateModel.class::cast).toList();
                for (PaletteTemplateModel model : models) {
                    context.add(new ModelMatchEntry(model.template()));
                }
            }
            composite.slots().stream().map(slot -> CompositeModelEntry.findUpgradeModel(slot, composite, context, provider)).flatMap(Optional::stream).forEach(compositeModelTemplate::add);
            return Optional.of(compositeModelTemplate);
        }
        return Optional.empty();
    }

    private Optional<ModelTemplate> convert(State state, ModelProvider provider, MatchContext context) {
        Optional<ModelMatcher> modelMatcher = provider.find(state);
        return modelMatcher.filter(matcher -> matcher.match(state, context)).flatMap(matcher -> matcher.get(state, provider, context));
    }

    @Override
    public int compareTo(@NotNull ModelMatcher o) {
        return 0;
    }
}

