/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.sigmundgranaas.forgero.core.model.CompositeModelEntry;
import com.sigmundgranaas.forgero.core.model.MatchedModelEntry;
import com.sigmundgranaas.forgero.core.model.ModelMatchPairing;
import com.sigmundgranaas.forgero.core.model.ModelMatcher;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.model.PaletteTemplateModel;
import com.sigmundgranaas.forgero.core.model.TemplatedModelEntry;
import com.sigmundgranaas.forgero.core.model.TextureModel;
import com.sigmundgranaas.forgero.core.model.match.PredicateFactory;
import com.sigmundgranaas.forgero.core.model.match.PredicateMatcher;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ModelData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ModelEntryData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.PaletteData;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.texture.utils.Offset;
import com.sigmundgranaas.forgero.core.type.TypeTree;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModelConverter {
    private final TypeTree tree;
    private final HashMap<String, ModelMatcher> models;
    private final HashMap<String, ArrayList<ModelData>> delayedModels;
    private final Map<String, PaletteData> palettes;
    private final HashMap<String, ModelData> generationModels;
    private final Map<String, ModelTemplate> textures;

    public ModelConverter(TypeTree tree, Map<String, PaletteData> palettes, HashMap<String, ModelMatcher> models, Map<String, ModelTemplate> textures, HashMap<String, ArrayList<ModelData>> delayedModels, HashMap<String, ModelData> generationModels) {
        this.tree = tree;
        this.palettes = palettes;
        this.delayedModels = delayedModels;
        this.generationModels = generationModels;
        this.models = models;
        this.textures = textures;
    }

    public static boolean notEmpty(String test) {
        return !test.equals(Identifiers.EMPTY_IDENTIFIER);
    }

    public void register(DataResource resource) {
        resource.models().forEach(data -> this.register((ModelData)data, resource.type()));
    }

    public void register(ModelData data, String type) {
        if (data.getName().equals(Identifiers.EMPTY_IDENTIFIER)) {
            this.handleEmptyIdentifier(data, type);
        } else if (ModelConverter.notEmpty(data.getName())) {
            this.handleNonEmptyIdentifier(data);
        }
    }

    private void handleEmptyIdentifier(ModelData data, String type) {
        ModelMatcher model = this.createModelMatcher(data);
        this.tree.find(type).ifPresent(node -> node.addResource(model, ModelMatcher.class));
    }

    private ModelMatcher createModelMatcher(ModelData data) {
        PredicateMatcher match = PredicateMatcher.of(data.getPredicates(), new PredicateFactory());
        return switch (data.getModelType()) {
            case "BASED_COMPOSITE", "UPGRADE" -> new ModelMatchPairing(match, new TemplatedModelEntry(data.getTemplate()));
            case "COMPOSITE" -> new ModelMatchPairing(match, new CompositeModelEntry());
            default -> ModelMatcher.EMPTY;
        };
    }

    private void handleNonEmptyIdentifier(ModelData data) {
        if (data.getTemplate().equals(Identifiers.EMPTY_IDENTIFIER)) {
            if (this.generationModels.containsKey(data.getName())) {
                this.processGeneratedModels(data);
            } else {
                this.delayModelProcessing(data);
            }
        } else {
            this.processNonGeneratedModels(data);
        }
    }

    private void processGeneratedModels(ModelData data) {
        ModelData modelData = this.generationModels.get(data.getName()).toBuilder().variants(data.getVariants()).build();
        List<ModelMatchPairing> pairings = this.pairings(modelData);
        MatchedModelEntry model = new MatchedModelEntry(pairings, data.getName());
        this.addOrUpdateModel(data, model, pairings);
    }

    private void delayModelProcessing(ModelData data) {
        this.delayedModels.computeIfAbsent(data.getName(), k -> new ArrayList()).add(data);
    }

    private void processNonGeneratedModels(ModelData data) {
        this.generationModels.put(data.getName(), data);
        ImmutableList.Builder variantsBuilder = ImmutableList.builder().addAll(data.getVariants());
        if (this.delayedModels.containsKey(data.getName())) {
            variantsBuilder.addAll(this.delayedModels.get(data.getName()).stream().map(ModelData::getVariants).flatMap(Collection::stream).toList());
            this.delayedModels.remove(data.getName());
        }
        ModelData modelData = data.toBuilder().variants((List<ModelEntryData>)variantsBuilder.build()).build();
        List<ModelMatchPairing> pairings = this.pairings(modelData);
        MatchedModelEntry model = new MatchedModelEntry(pairings, data.getName());
        this.addOrUpdateModel(data, model, pairings);
    }

    private void addOrUpdateModel(ModelData data, ModelMatcher model, List<ModelMatchPairing> pairings) {
        ModelMatcher modelMatcher;
        if (this.models.containsKey(data.getName()) && (modelMatcher = this.models.get(data.getName())) instanceof MatchedModelEntry) {
            MatchedModelEntry existingMatcher = (MatchedModelEntry)modelMatcher;
            existingMatcher.add(pairings);
        } else {
            this.models.put(data.getName(), model);
        }
    }

    private List<ModelMatchPairing> pairings(ModelData data) {
        List<PaletteData> palettes = this.findPalettes(data);
        if (!data.getModelType().equals("GENERATE")) {
            return this.createPairings(palettes, data);
        }
        return this.generatePairings(palettes, data);
    }

    private List<PaletteData> findPalettes(ModelData data) {
        PaletteData paletteData;
        List<PaletteData> palettes = (List<PaletteData>)this.tree.find(data.getPalette()).map(node -> node.getResources(PaletteData.class)).orElse(ImmutableList.builder().build());
        if (palettes.isEmpty() && (paletteData = this.palettes.get(data.getPalette())) != null) {
            palettes = List.of(paletteData);
        }
        return palettes;
    }

    private List<ModelMatchPairing> generatePairings(List<PaletteData> palettes, ModelData data) {
        return palettes.stream().map(palette -> data.toBuilder().palette(palette.getTarget()).build()).map(this::buildVariants).flatMap(Collection::stream).map(model -> this.generate((ModelData)model, (List<JsonElement>)List.of(new JsonPrimitive("name:" + model.getPalette())))).toList();
    }

    private List<ModelMatchPairing> createPairings(List<PaletteData> palettes, ModelData data) {
        return palettes.stream().map(palette -> data.toBuilder().palette(palette.getTarget()).build()).map(this::buildVariants).flatMap(Collection::stream).map(model -> this.generate((ModelData)model, (List<JsonElement>)List.of(new JsonPrimitive("name:" + model.getPalette())))).toList();
    }

    private List<ModelData> buildVariants(ModelData data) {
        return Stream.concat(data.getVariants().stream().map(variant -> data.toBuilder().children((List<ModelData>)ImmutableList.builder().addAll(data.getChildren()).addAll(variant.getChildren()).build()).texture(variant.getTexture().equals(Identifiers.EMPTY_IDENTIFIER) ? data.getTexture() : variant.getTexture()).template(variant.getTemplate().equals(Identifiers.EMPTY_IDENTIFIER) ? data.getTemplate() : variant.getTemplate()).palette(variant.getPalette().equals(Identifiers.EMPTY_IDENTIFIER) ? data.getPalette() : variant.getPalette()).predicate(variant.getTarget()).offset(variant.getOffset()).resolution(variant.getResolution()).order(data.order()).build()), Stream.of(data)).collect(Collectors.toList());
    }

    private ModelMatchPairing generate(ModelData data, List<JsonElement> additionalPredicates) {
        ArrayList<JsonElement> predicates = new ArrayList<JsonElement>(data.getPredicates());
        predicates.addAll(additionalPredicates);
        ModelMatcher model = this.createTemplate(data);
        return new ModelMatchPairing(PredicateMatcher.of(predicates, new PredicateFactory()), model);
    }

    private ModelMatcher createTemplate(ModelData data) {
        List<ModelTemplate> children = data.getChildren().stream().map(this::createTemplate).map(ModelTemplate.class::cast).toList();
        if (data.getTemplate().contains(Identifiers.EMPTY_IMAGE_IDENTIFIER)) {
            return ModelMatcher.EMPTY_TRUE;
        }
        Record template = data.getTexture().equals(Identifiers.EMPTY_IDENTIFIER) ? new PaletteTemplateModel(data.getPalette(), data.getTemplate(), data.order(), Offset.of(data.getOffset()), data.getResolution(), data.displayOverrides().orElse(null), data.getParent().orElse(null), children) : new TextureModel(data.getTexture(), data.order(), Offset.of(data.getOffset()), data.getResolution(), data.displayOverrides().orElse(null), data.getParent().orElse(null), children);
        Identifiable identifiable = template;
        this.textures.put(identifiable.identifier(), (ModelTemplate)((Object)template));
        return template;
    }
}

