/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model;

import com.sigmundgranaas.forgero.core.model.Converter;
import com.sigmundgranaas.forgero.core.model.ModelMatchPairing;
import com.sigmundgranaas.forgero.core.model.ModelProvider;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.model.match.PredicateMatcher;
import com.sigmundgranaas.forgero.core.model.match.predicate.IdPredicate;
import com.sigmundgranaas.forgero.core.model.match.predicate.ModelPredicate;
import com.sigmundgranaas.forgero.core.texture.utils.Offset;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public interface ModelMatcher
extends Comparable<ModelMatcher> {
    public static final ModelMatcher EMPTY_TRUE = new ModelMatcher(){

        @Override
        public int compareTo(@NotNull ModelMatcher o) {
            return ModelMatcher.comparator(this, o);
        }

        @Override
        public boolean match(Matchable state, MatchContext context) {
            return true;
        }

        @Override
        public Optional<ModelTemplate> get(Matchable state, ModelProvider provider, MatchContext context) {
            return Optional.of(EMPTY_TEMPLATE);
        }
    };
    public static final ModelTemplate EMPTY_TEMPLATE = new ModelTemplate(){

        @Override
        public int order() {
            return 0;
        }

        @Override
        public Optional<Offset> getOffset() {
            return Optional.empty();
        }

        @Override
        public <T> T convert(Converter<T, ModelTemplate> converter) {
            return converter.convert(this);
        }
    };
    public static final ModelMatcher EMPTY = new ModelMatcher(){

        @Override
        public int compareTo(@NotNull ModelMatcher o) {
            return ModelMatcher.comparator(this, o);
        }

        @Override
        public boolean match(Matchable state, MatchContext context) {
            return false;
        }

        @Override
        public Optional<ModelTemplate> get(Matchable state, ModelProvider provider, MatchContext context) {
            return Optional.empty();
        }
    };

    public static int comparator(ModelMatcher match1, ModelMatcher match2) {
        if (match1 instanceof ModelMatchPairing) {
            ModelMatchPairing entry1 = (ModelMatchPairing)match1;
            if (match2 instanceof ModelMatchPairing) {
                ModelMatchPairing entry2 = (ModelMatchPairing)match2;
                PredicateMatcher matcher1 = entry1.match();
                PredicateMatcher matcher2 = entry2.match();
                boolean match1Identifier = matcher1.getPredicates().stream().anyMatch(match -> match instanceof IdPredicate);
                boolean match2Identifier = matcher2.getPredicates().stream().anyMatch(match -> match instanceof IdPredicate);
                boolean match1Model = matcher1.getPredicates().stream().anyMatch(match -> match instanceof ModelPredicate);
                boolean match2Model = matcher2.getPredicates().stream().anyMatch(match -> match instanceof ModelPredicate);
                if (match1Identifier && !match2Identifier) {
                    return -1;
                }
                if (match2Identifier && !match1Identifier) {
                    return 1;
                }
                if (match1Model && !match2Model) {
                    return -1;
                }
                if (match2Model && !match1Model) {
                    return 1;
                }
                return Integer.compare(matcher2.getPredicates().size(), matcher1.getPredicates().size());
            }
        }
        return 0;
    }

    public boolean match(Matchable var1, MatchContext var2);

    public Optional<ModelTemplate> get(Matchable var1, ModelProvider var2, MatchContext var3);

    @Override
    default public int compareTo(@NotNull ModelMatcher o) {
        return ModelMatcher.comparator(this, o);
    }
}

