/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.model.ModelConverter;
import com.sigmundgranaas.forgero.core.model.ModelMatcher;
import com.sigmundgranaas.forgero.core.model.ModelResult;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.model.MultipleModelMatcher;
import com.sigmundgranaas.forgero.core.resource.ResourceListener;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ModelData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.PaletteData;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.TypeTree;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ModelRegistry {
    private final HashMap<String, ModelMatcher> modelMap;
    private final Map<String, ModelTemplate> textures;
    private final Map<String, String> paletteRemapper;
    private final Map<String, PaletteData> palettes;
    private final HashMap<String, ArrayList<ModelData>> delayedModels;
    private final HashMap<String, ModelData> generationModels;
    private TypeTree tree;

    public ModelRegistry(TypeTree tree) {
        this.tree = tree;
        this.palettes = new HashMap<String, PaletteData>();
        this.modelMap = new HashMap();
        this.paletteRemapper = new HashMap<String, String>();
        this.textures = new HashMap<String, ModelTemplate>();
        this.delayedModels = new HashMap();
        this.generationModels = new HashMap();
    }

    public ModelRegistry() {
        this.tree = new TypeTree();
        this.palettes = new HashMap<String, PaletteData>();
        this.modelMap = new HashMap();
        this.textures = new HashMap<String, ModelTemplate>();
        this.delayedModels = new HashMap();
        this.paletteRemapper = new HashMap<String, String>();
        this.generationModels = new HashMap();
    }

    public ResourceListener<List<DataResource>> modelListener() {
        return (resources, tree, idMapper) -> {
            this.tree = tree;
            resources.stream().filter(resource -> !resource.models().isEmpty()).forEach(this::register);
        };
    }

    public ResourceListener<List<DataResource>> paletteListener() {
        return (resources, tree, idMapper) -> resources.stream().filter(res -> res.palette().isPresent()).forEach(res -> this.paletteHandler((DataResource)res, tree));
    }

    private void paletteHandler(DataResource resource, TypeTree tree) {
        Optional<PaletteData> paletteData = resource.palette();
        if (paletteData.isPresent()) {
            PaletteData palette = paletteData.get().toBuilder().target(resource.name()).build();
            tree.find(resource.type()).ifPresent(node -> node.addResource(palette, PaletteData.class));
            this.palettes.put(palette.getName(), palette);
            if (!paletteData.get().getName().equals(resource.name())) {
                this.paletteRemapper.put(resource.name() + ".png", paletteData.get().getName() + ".png");
            }
        }
    }

    public void setTree(TypeTree tree) {
        this.tree = tree;
    }

    public ModelRegistry register(DataResource data) {
        ModelConverter converter = new ModelConverter(this.tree, this.palettes, this.modelMap, this.textures, this.delayedModels, this.generationModels);
        converter.register(data);
        return this;
    }

    public Optional<ModelResult> find(State state, MatchContext context) {
        if (this.modelMap.containsKey(state.identifier())) {
            return this.modelMap.get(state.identifier()).get(state, this::provider, MatchContext.of()).map(model -> new ModelResult().setTemplate((ModelTemplate)model));
        }
        ModelResult result = new ModelResult();
        context.put(ModelResult.MODEL_RESULT, (Object)result);
        ImmutableList modelEntries = this.tree.find(state.type().typeName()).map(node -> node.getResources(ModelMatcher.class)).orElse(ImmutableList.builder().build());
        return modelEntries.stream().sorted(ModelMatcher::comparator).filter(entry -> entry.match(state, context)).map(modelMatcher -> modelMatcher.get(state, this::provider, context)).flatMap(Optional::stream).findFirst().map(result::setTemplate);
    }

    public Optional<ModelResult> find(State state) {
        return this.find(state, MatchContext.of());
    }

    public Optional<ModelMatcher> provider(Identifiable id) {
        if (this.modelMap.containsKey(id.identifier())) {
            return Optional.ofNullable(this.modelMap.get(id.identifier()));
        }
        if (this.modelMap.containsKey(id.name())) {
            return Optional.ofNullable(this.modelMap.get(id.name()));
        }
        if (id instanceof State) {
            State state = (State)id;
            return Optional.of(MultipleModelMatcher.of((List)this.tree.find(state.type().typeName()).map(node -> node.getResources(ModelMatcher.class)).orElse(ImmutableList.builder().build())));
        }
        return Optional.empty();
    }

    public Map<String, ModelTemplate> getTextures() {
        return this.textures;
    }

    public Map<String, String> getPaletteRemapper() {
        return this.paletteRemapper;
    }
}

