/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model;

import com.sigmundgranaas.forgero.core.model.CompositeModelTemplate;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.util.match.ContextKey;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ModelResult {
    public static final ModelResult EMPTY = new ModelResult();
    public static final ContextKey<ModelResult> MODEL_RESULT = new ContextKey<ModelResult>("MODEL_RESULT", ModelResult.class);
    private final List<Matchable> invalidationOptions;
    @Nullable
    private ModelTemplate template = new CompositeModelTemplate();

    public ModelResult() {
        this.invalidationOptions = new ArrayList<Matchable>();
    }

    public boolean isValid(Matchable matchable, MatchContext context) {
        if (this.invalidationOptions.isEmpty()) {
            return true;
        }
        for (Matchable test : this.invalidationOptions) {
            if (!test.test(matchable, context)) continue;
            return false;
        }
        return true;
    }

    public List<Boolean> footprint(Matchable matchable, MatchContext context) {
        return this.invalidationOptions.stream().map(option -> option.test(matchable, context)).toList();
    }

    public ModelResult addOptions(Matchable options) {
        this.invalidationOptions.add(options);
        return this;
    }

    public ModelResult setTemplate(ModelTemplate template) {
        this.template = template;
        return this;
    }

    @Nullable
    public ModelTemplate getTemplate() {
        return this.template;
    }
}

