/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.model.Converter;
import com.sigmundgranaas.forgero.core.model.ModelMatcher;
import com.sigmundgranaas.forgero.core.model.ModelProvider;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.texture.utils.Offset;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PaletteTemplateModel(String palette, String template, int order, @Nullable Offset offset, @Nullable Integer resolution, @Nullable JsonObject displayOverrides, @Nullable String parent, List<ModelTemplate> children) implements ModelTemplate,
ModelMatcher,
Identifiable
{
    @Override
    public Optional<Offset> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    @Override
    public Integer getResolution() {
        return Optional.ofNullable(this.resolution).orElse(16);
    }

    @Override
    public Optional<JsonObject> getDisplayOverrides() {
        return Optional.ofNullable(this.displayOverrides);
    }

    @Override
    public Optional<String> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public <T> T convert(Converter<T, ModelTemplate> converter) {
        return converter.convert(this);
    }

    @Override
    public boolean match(Matchable state, MatchContext context) {
        return true;
    }

    @Override
    public Optional<ModelTemplate> get(Matchable state, ModelProvider provider, MatchContext context) {
        return Optional.of(this);
    }

    @Override
    public String name() {
        return String.format("%s-%s", this.palette, this.template);
    }

    @Override
    public String nameSpace() {
        return String.format("%s", "forgero");
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public int compareTo(@NotNull ModelMatcher o) {
        if (o instanceof ModelTemplate) {
            ModelTemplate templateO = (ModelTemplate)((Object)o);
            return this.order() - templateO.order();
        }
        return 0;
    }
}

