/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model;

import com.sigmundgranaas.forgero.core.model.CompositeModelEntry;
import com.sigmundgranaas.forgero.core.model.CompositeModelTemplate;
import com.sigmundgranaas.forgero.core.model.ModelMatchEntry;
import com.sigmundgranaas.forgero.core.model.ModelMatcher;
import com.sigmundgranaas.forgero.core.model.ModelProvider;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.model.PaletteTemplateModel;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.Optional;

public record TemplatedModelEntry(String template) implements ModelMatcher
{
    @Override
    public boolean match(Matchable state, MatchContext context) {
        return true;
    }

    @Override
    public Optional<ModelTemplate> get(Matchable state, ModelProvider provider, MatchContext context) {
        Optional<ModelTemplate> templateModel = provider.find(Identifiable.of(this.template)).filter(matcher -> matcher.match(state, context)).flatMap(matcher -> matcher.get(state, provider, context));
        if (state instanceof Composite) {
            Composite construct = (Composite)state;
            context.add(construct.type()).add(new NameMatch(construct.name()));
            CompositeModelTemplate compositeModelTemplate = new CompositeModelTemplate();
            templateModel.ifPresent(compositeModelTemplate::add);
            templateModel.ifPresent(model -> this.addModelToContext((ModelTemplate)model, context));
            construct.slots().stream().filter(Slot::filled).map(slot -> CompositeModelEntry.findUpgradeModel(slot, construct, context, provider)).flatMap(Optional::stream).forEach(compositeModelTemplate::add);
            return Optional.of(compositeModelTemplate);
        }
        return templateModel;
    }

    private void addModelToContext(ModelTemplate template, MatchContext context) {
        if (template instanceof PaletteTemplateModel) {
            PaletteTemplateModel templateModel = (PaletteTemplateModel)template;
            context.add(new ModelMatchEntry(templateModel.template()));
        }
    }
}

