/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model.match;

import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Typed;
import com.sigmundgranaas.forgero.core.state.composite.Constructed;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.ArrayList;
import java.util.List;

public class CompositeStrategy
implements Matchable {
    private final List<Matchable> predicates;
    private final Matchable compositeStrategy = (match, context) -> {
        Composite composite = (Composite)match;
        return this.matchAgainstPredicates(composite.slots(), context);
    };
    private final Matchable constructedStrategy = (match, context) -> {
        Constructed construct = (Constructed)((Object)match);
        return this.matchAgainstPredicates(construct.parts(), context);
    };

    public CompositeStrategy(List<Matchable> predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        MatchContext compositeContext = context;
        if (match instanceof Typed) {
            Typed identifiable = (Typed)((Object)match);
            compositeContext = compositeContext.add(identifiable.type());
        }
        if (match instanceof Composite && match instanceof Constructed) {
            return this.constructedStrategy.test(match, compositeContext);
        }
        return false;
    }

    private boolean matchAgainstPredicates(List<? extends Matchable> items, MatchContext context) {
        ArrayList<Matchable> matches = new ArrayList<Matchable>();
        for (Matchable matchable : items) {
            for (Matchable predicate : this.predicates) {
                if (!predicate.test(matchable, context) || matches.contains(predicate)) continue;
                matches.add(predicate);
            }
        }
        return matches.size() == this.predicates.size();
    }
}

