/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model.match;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.model.match.builders.PredicateBuilder;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class PredicateFactory {
    private static final List<PredicateBuilder> builders = new ArrayList<PredicateBuilder>();
    private static final List<Codec<? extends Matchable>> codecs = new ArrayList<Codec<? extends Matchable>>();
    private static final LoadingCache<JsonElement, Matchable> cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<JsonElement, Matchable>(){

        @NotNull
        public Matchable load(@NotNull JsonElement element) {
            return builders.stream().map(builder -> builder.create(element)).flatMap(Optional::stream).findAny().or(() -> codecs.stream().map(codec -> codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element)).map(DataResult::result).flatMap(Optional::stream).findAny()).orElseGet(() -> {
                Forgero.LOGGER.error("Found predicate element with no corresponding predicate builder: {}, the corresponding entry will always fail matching checks.", (Object)element);
                return Matchable.DEFAULT_FALSE;
            });
        }
    });

    public static void register(PredicateBuilder builder) {
        builders.add(builder);
    }

    public static void register(Codec<? extends Matchable> builder) {
        codecs.add(builder);
    }

    public static void register(Supplier<PredicateBuilder> builder) {
        builders.add(builder.get());
    }

    public Matchable create(JsonElement element) {
        try {
            return (Matchable)cache.get((Object)element);
        }
        catch (Exception e) {
            return Matchable.DEFAULT_FALSE;
        }
    }
}

