/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model.match;

import com.google.gson.JsonElement;
import com.sigmundgranaas.forgero.core.model.match.DefaultMatcher;
import com.sigmundgranaas.forgero.core.model.match.PredicateFactory;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.List;
import java.util.stream.Collectors;

public abstract class PredicateMatcher
implements Matchable {
    protected final List<Matchable> predicates;

    public PredicateMatcher(List<JsonElement> predicates, PredicateFactory predicateFactory) {
        this.predicates = predicates.stream().map(predicateFactory::create).collect(Collectors.toList());
    }

    public static PredicateMatcher of(List<JsonElement> predicates, PredicateFactory factory) {
        return new DefaultMatcher(predicates, factory);
    }

    public List<Matchable> getPredicates() {
        return this.predicates;
    }

    public List<Matchable> getDynamicPredicates() {
        return this.getPredicates().stream().filter(Matchable::isDynamic).toList();
    }

    public abstract boolean testDynamic(Matchable var1, MatchContext var2);
}

