/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model.match;

import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.FilledSlot;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.List;
import java.util.Optional;

public class SlotStrategy
implements Matchable {
    private final List<Matchable> predicates;

    public SlotStrategy(List<Matchable> predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof FilledSlot) {
            FilledSlot slot = (FilledSlot)match;
            boolean matchesAllSlots = this.predicates.stream().allMatch(pred -> pred.test(slot, context));
            if (matchesAllSlots) {
                return true;
            }
            Optional<State> slotContentOpt = slot.get();
            if (slotContentOpt.isPresent()) {
                return this.predicates.stream().allMatch(pred -> pred.test(slot, context));
            }
        }
        return false;
    }
}

