/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.model.match.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;

public class ElementParser {
    public static Optional<JsonObject> fromIdentifiedElement(JsonElement element, String type) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            return Optional.of(object).filter(jsonObject -> ElementParser.checkIdOrType(jsonObject, type));
        }
        return Optional.empty();
    }

    public static boolean checkIdOrType(JsonObject jsonObject, String type) {
        return jsonObject.has("type") && jsonObject.get("type").getAsString().equals(type) || jsonObject.has("id") && jsonObject.get("id").getAsString().equals(type) || jsonObject.has("condition") && jsonObject.get("condition").getAsString().equals(type);
    }

    public static Optional<String> fromString(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return Optional.of(element.getAsJsonPrimitive().getAsString());
        }
        return Optional.empty();
    }
}

