/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.sigmundgranaas.forgero.core.context.Context;
import com.sigmundgranaas.forgero.core.property.CalculationOrder;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.AttributeBuilder;
import com.sigmundgranaas.forgero.core.property.attribute.BaseAttribute;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.property.attribute.SimpleAttribute;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public interface Attribute
extends Property,
Comparable<Attribute> {
    public static final Function<Float, Float> DEFAULT_ATTRIBUTE_CALCULATION = currentFloat -> currentFloat;

    public static Codec<Attribute> defaultOrExplicitTypeCodec(String defaultType) {
        Codec codec = Codec.either((Codec)Codec.FLOAT, (Codec)Codec.either(SimpleAttribute.CODEC, BaseAttribute.BaseAttributeCodec.CODEC));
        return codec.xmap(either -> (Attribute)either.map(value -> new SimpleAttribute(defaultType, value.floatValue()), eitherSimpleOrComplex -> (Record)eitherSimpleOrComplex.map(simpleAttribute -> simpleAttribute, baseAttribute -> baseAttribute)), attribute -> {
            if (attribute instanceof BaseAttribute) {
                BaseAttribute baseAttribute = (BaseAttribute)attribute;
                return Either.right((Object)Either.right((Object)baseAttribute));
            }
            if (attribute instanceof SimpleAttribute) {
                SimpleAttribute simpleAttribute = (SimpleAttribute)attribute;
                return Either.right((Object)Either.left((Object)simpleAttribute));
            }
            return Either.left((Object)Float.valueOf(attribute.getValue()));
        });
    }

    default public CalculationOrder getOrder() {
        return CalculationOrder.BASE;
    }

    @Override
    default public int compareTo(@NotNull Attribute o) {
        int order;
        if (o.getAttributeType().equals(this.getAttributeType())) {
            boolean hasTargetDefaultPredicate;
            boolean hasDefaultPredicate = this.getPredicate() == Matchable.DEFAULT_TRUE;
            boolean bl = hasTargetDefaultPredicate = o.getPredicate() == Matchable.DEFAULT_TRUE;
            if (hasDefaultPredicate && !hasTargetDefaultPredicate) {
                return -1;
            }
            if (hasTargetDefaultPredicate && !hasDefaultPredicate) {
                return 1;
            }
        }
        if ((order = this.getOrder().getValue() - o.getOrder().getValue()) == 0) {
            return this.getOperation().ordinal() - o.getOperation().ordinal();
        }
        return order;
    }

    public String getAttributeType();

    default public Function<Float, Float> getCalculation() {
        return DEFAULT_ATTRIBUTE_CALCULATION;
    }

    default public Matchable getPredicate() {
        return Matchable.DEFAULT_TRUE;
    }

    public NumericOperation getOperation();

    public float getValue();

    public Category getCategory();

    public int getLevel();

    public List<String> targets();

    public String targetType();

    public Context getContext();

    public int getPriority();

    public String getId();

    public float leveledValue();

    default public Optional<PropertyContainer> source() {
        return Optional.empty();
    }

    default public Attribute setSource(PropertyContainer source) {
        return AttributeBuilder.createAttributeBuilderFromAttribute(this).applySource(source).build();
    }

    @Override
    default public float applyAttribute(Matchable target, MatchContext context, float currentAttribute) {
        if (this.getPredicate().test(target, context)) {
            return this.getCalculation().apply(Float.valueOf(currentAttribute)).floatValue();
        }
        return currentAttribute;
    }

    @Override
    default public boolean applyCondition(Matchable target, MatchContext context) {
        return this.getPredicate().test(target, context);
    }

    public ComputedAttribute compute();

    default public PropertyContainer container() {
        return PropertyContainer.of(this);
    }
}

