/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CompositeContainer
implements PropertyContainer {
    private final List<PropertyContainer> containers;

    public CompositeContainer(List<PropertyContainer> containers) {
        this.containers = containers;
    }

    @Override
    public PropertyContainer with(PropertyContainer container) {
        return new CompositeContainer((List<PropertyContainer>)ImmutableList.builder().addAll(this.containers).add((Object)container).build());
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return this.containers.stream().map(PropertyContainer::getRootProperties).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.containers.stream().map(PropertyContainer::getRootProperties).flatMap(Collection::stream).filter(prop -> prop.applyCondition(target, context)).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeContainer that = (CompositeContainer)o;
        return Objects.equals(this.containers, that.containers);
    }

    public int hashCode() {
        return Objects.hash(this.containers);
    }
}

