/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property;

import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.CompositeContainer;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyStream;
import com.sigmundgranaas.forgero.core.property.SimpleContainer;
import com.sigmundgranaas.forgero.core.property.SingleContainer;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public interface PropertyContainer
extends Comparable<Object> {
    public static final PropertyContainer EMPTY = new SimpleContainer(Collections.emptyList());
    public static final Function<PropertyContainer, Float> ATTACK_DAMAGE = container -> Float.valueOf(Property.stream(container.getProperties()).applyAttribute("ATTACK_DAMAGE"));
    public static final Function<PropertyContainer, Integer> RARITY = container -> (int)Property.stream(container.getProperties()).applyAttribute("RARITY");

    public static PropertyContainer of(List<Property> properties) {
        return new SimpleContainer(properties);
    }

    public static PropertyContainer of(Property properties) {
        return new SingleContainer(properties);
    }

    default public PropertyContainer with(PropertyContainer container) {
        return new CompositeContainer(List.of(this, container));
    }

    @Deprecated
    @NotNull
    default public List<Property> getProperties(Matchable target, MatchContext context) {
        return this.applyProperty(target, context);
    }

    @NotNull
    default public List<Property> getProperties() {
        return this.getRootProperties();
    }

    @NotNull
    default public PropertyStream stream() {
        return Property.stream(this.getRootProperties(), Matchable.DEFAULT_TRUE, MatchContext.of());
    }

    @NotNull
    default public PropertyStream stream(Matchable target, MatchContext context) {
        return Property.stream(this.getRootProperties(target, context), target, context);
    }

    @NotNull
    default public PropertyStream stream(Matchable target) {
        return Property.stream(this.getRootProperties(target, MatchContext.of()));
    }

    default public Property applySource(Property property) {
        if (property instanceof Attribute) {
            Attribute attribute = (Attribute)property;
            return attribute.setSource(this);
        }
        return property;
    }

    @NotNull
    default public List<Property> getRootProperties() {
        return Collections.emptyList();
    }

    @NotNull
    public List<Property> getRootProperties(Matchable var1, MatchContext var2);

    @NotNull
    default public List<Property> applyProperty(Matchable target, MatchContext context) {
        return this.getRootProperties().stream().filter(property -> property.applyCondition(target, context)).toList();
    }

    @Override
    default public int compareTo(@NotNull Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof PropertyContainer) {
            PropertyContainer container = (PropertyContainer)o;
            return RARITY.apply(this) - RARITY.apply(container);
        }
        return 0;
    }
}

