/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property;

import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.Feature;
import com.sigmundgranaas.forgero.core.util.ForwardingStream;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.List;
import java.util.stream.Stream;

public record PropertyStream(Stream<Property> stream, Matchable target, MatchContext context) implements ForwardingStream<Property>
{
    private static final PropertyStream EMPTY = new PropertyStream(Stream.empty(), Matchable.DEFAULT_TRUE, MatchContext.of());

    public static PropertyStream empty() {
        return EMPTY;
    }

    @Override
    public Stream<Property> getStream() {
        return this.stream;
    }

    public float applyAttribute(String attributeType) {
        return this.getAttributeOfType(attributeType).reduce(Float.valueOf(0.0f), (collector, attribute) -> Float.valueOf(attribute.applyAttribute(this.target, this.context, collector.floatValue())), (a, b) -> b).floatValue();
    }

    public ComputedAttribute compute(String attributeType) {
        return ComputedAttribute.of(this.applyAttribute(attributeType), attributeType);
    }

    public Stream<Attribute> getAttributeOfType(String attributeType) {
        List<Attribute> rootAttributes = this.getAttributes().filter(attribute -> attributeType.equals(attribute.getAttributeType())).toList();
        return rootAttributes.stream().sorted(Attribute::compareTo);
    }

    public Stream<Attribute> getAttributes() {
        return this.stream.filter(property -> property instanceof Attribute).map(Attribute.class::cast);
    }

    public Stream<Feature> features() {
        return this.stream.filter(property -> property instanceof Feature).map(Feature.class::cast);
    }

    public <T extends Feature> Stream<T> features(ClassKey<T> key) {
        return this.stream.filter(property -> property.type().equals(key.type())).filter(key.clazz()::isInstance).map(key.clazz()::cast);
    }

    public PropertyStream with(Property property) {
        return new PropertyStream(Stream.concat(this.stream, Stream.of(property)), this.target, this.context);
    }

    public PropertyStream with(Stream<Property> properties) {
        return new PropertyStream(Stream.concat(this.stream, properties), this.target, this.context);
    }

    public PropertyStream with(PropertyStream properties) {
        return new PropertyStream(Stream.concat(this.stream, properties), this.target, this.context);
    }
}

