/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property;

import com.sigmundgranaas.forgero.core.property.TargetTypes;
import com.sigmundgranaas.forgero.core.property.attribute.CompoundTarget;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface Target {
    public static final Target EMPTY = Target.createEmptyTarget();

    public static Target createEmptyTarget() {
        return new Target(){

            @Override
            public boolean isApplicable(Set<String> tag, TargetTypes type) {
                return false;
            }

            @Override
            public Set<TargetTypes> getTypes() {
                return Collections.emptySet();
            }

            @Override
            public Set<String> getTags() {
                return Collections.emptySet();
            }

            public int hashCode() {
                return 0;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isApplicable(Set<String> tag, TargetTypes type) {
        if (!this.getTypes().contains((Object)type)) return false;
        if (!this.getTags().stream().anyMatch(tag::contains)) return false;
        return true;
    }

    public Set<TargetTypes> getTypes();

    public Set<String> getTags();

    default public Target combineTarget(Target target) {
        return new CompoundTarget(List.of(this, target));
    }
}

