/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.attribute;

import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.state.State;
import java.util.List;

public class AttributeHelper {
    private final State state;

    public AttributeHelper(State state) {
        this.state = state;
    }

    public static AttributeHelper of(State state) {
        return new AttributeHelper(state);
    }

    public float attribute(String type) {
        return switch (type) {
            case "RARITY" -> this.rarity();
            case "MINING_LEVEL" -> this.miningLevel();
            case "DURABILITY" -> this.durability();
            default -> 0.0f;
        };
    }

    public int rarity() {
        int rarity = (int)this.state.stream().applyAttribute("RARITY");
        return rarity;
    }

    public int miningLevel() {
        return (int)this.state.stream().applyAttribute("MINING_LEVEL");
    }

    public int durability() {
        return ComputedAttribute.of(this.state, "DURABILITY").asInt();
    }

    public List<Property> attributes() {
        return this.state.getRootProperties();
    }
}

