/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sigmundgranaas.forgero.core.context.Context;
import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.CalculationOrder;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.property.attribute.SimpleAttribute;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public record BaseAttribute(String attribute, NumericOperation operation, float value, Matchable condition, CalculationOrder order, int level, Category category, String id, List<String> targets, String targetType, int priority, Context context, @Nullable PropertyContainer attributeSource) implements Attribute
{
    public static Attribute of(int value, String type) {
        return new SimpleAttribute(type, value);
    }

    public static Attribute of(float value, String type) {
        return new SimpleAttribute(type, value);
    }

    @Override
    public CalculationOrder getOrder() {
        return Objects.requireNonNullElse(this.order, Attribute.super.getOrder());
    }

    @Override
    public String getAttributeType() {
        return this.attribute;
    }

    @Override
    public Function<Float, Float> getCalculation() {
        if (this.operation == NumericOperation.ADDITION) {
            return current -> Float.valueOf(current.floatValue() + this.leveledValue());
        }
        if (this.operation == NumericOperation.MULTIPLICATION) {
            return current -> Float.valueOf(current.floatValue() * this.leveledValue());
        }
        if (this.operation == NumericOperation.FORCE) {
            return current -> Float.valueOf(this.leveledValue());
        }
        return current -> current;
    }

    @Override
    public Matchable getPredicate() {
        return this.condition;
    }

    @Override
    public NumericOperation getOperation() {
        return this.operation;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public float leveledValue() {
        if (this.getOperation() == NumericOperation.MULTIPLICATION) {
            if (this.getValue() >= 1.0f) {
                return (this.getValue() - 1.0f) * (float)this.getLevel() + 1.0f;
            }
            if (this.getValue() < 1.0f) {
                return 1.0f - (1.0f - this.getValue()) * (float)this.getLevel();
            }
        }
        return this.value * (float)this.level;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public Context getContext() {
        return Objects.requireNonNullElse(this.context, Contexts.UNDEFINED);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String type() {
        return this.getAttributeType();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.attribute, this.operation, Float.valueOf(this.value), this.order, this.level, this.category, this.id, this.priority, this.context});
    }

    @Override
    public Optional<PropertyContainer> source() {
        return Optional.ofNullable(this.attributeSource());
    }

    @Override
    public ComputedAttribute compute() {
        return ComputedAttribute.of(this.leveledValue(), this.type());
    }

    @Override
    public String toString() {
        if (!this.id.equals(Identifiers.EMPTY_IDENTIFIER)) {
            return this.id;
        }
        return "BaseAttribute{attribute=" + this.attribute + ", operation=" + this.operation + ", value=" + this.value + ", condition=" + this.condition + ", order=" + this.order + ", level=" + this.level + ", category=" + this.category + ", id='" + this.id + "', priority=" + this.priority + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseAttribute that = (BaseAttribute)o;
        return Float.compare(this.value, that.value) == 0 && this.level == that.level && this.priority == that.priority && Objects.equals(this.attribute, that.attribute) && this.operation == that.operation && this.order == that.order && this.category == that.category && Objects.equals(this.id, that.id) && Objects.equals(this.context, that.context);
    }

    public static class BaseAttributeCodec {
        private static final NumericOperation DEFAULT_OPERATION = NumericOperation.ADDITION;
        private static final Matchable DEFAULT_CONDITION = Matchable.DEFAULT_TRUE;
        private static final CalculationOrder DEFAULT_ORDER = CalculationOrder.BASE;
        private static final int DEFAULT_LEVEL = 1;
        private static final Category DEFAULT_CATEGORY = Category.UNDEFINED;
        private static final String DEFAULT_ID = Identifiers.EMPTY_IDENTIFIER;
        private static final List<String> DEFAULT_TARGETS = Collections.emptyList();
        private static final String DEFAULT_TARGET_TYPE = Identifiers.EMPTY_IDENTIFIER;
        private static final int DEFAULT_PRIORITY = 0;
        private static final Context DEFAULT_CONTEXT = Contexts.UNDEFINED;
        public static final Codec<BaseAttribute> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(BaseAttribute::attribute), (App)NumericOperation.CODEC.optionalFieldOf("operation", (Object)DEFAULT_OPERATION).forGetter(BaseAttribute::operation), (App)Codec.FLOAT.fieldOf("value").forGetter(BaseAttribute::value), (App)Matchable.CODEC.optionalFieldOf("condition", (Object)DEFAULT_CONDITION).forGetter(BaseAttribute::condition), (App)CalculationOrder.CODEC.optionalFieldOf("order", (Object)DEFAULT_ORDER).forGetter(BaseAttribute::order), (App)Codec.INT.optionalFieldOf("level", (Object)1).forGetter(BaseAttribute::level), (App)Category.CODEC.optionalFieldOf("category", (Object)DEFAULT_CATEGORY).forGetter(BaseAttribute::category), (App)Codec.STRING.optionalFieldOf("id", (Object)DEFAULT_ID).forGetter(BaseAttribute::id), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("targets", DEFAULT_TARGETS).forGetter(BaseAttribute::targets), (App)Codec.STRING.optionalFieldOf("targetType", (Object)DEFAULT_TARGET_TYPE).forGetter(BaseAttribute::targetType), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(BaseAttribute::priority), (App)Context.CODEC.optionalFieldOf("context", (Object)DEFAULT_CONTEXT).forGetter(BaseAttribute::context)).apply((Applicative)instance, (type, operation, value, condition, order, level, category, id, targets, targetType, priority, context) -> new BaseAttribute((String)type, (NumericOperation)((Object)((Object)operation)), value.floatValue(), (Matchable)condition, (CalculationOrder)((Object)((Object)order)), (int)level, (Category)((Object)((Object)category)), (String)id, (List<String>)targets, (String)targetType, (int)priority, (Context)context, null)));
    }
}

