/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sigmundgranaas.forgero.core.context.Context;
import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public record SimpleAttribute(String attribute, float value) implements Attribute
{
    public static final Codec<SimpleAttribute> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(SimpleAttribute::attribute), (App)Codec.FLOAT.fieldOf("value").forGetter(SimpleAttribute::value)).apply((Applicative)instance, SimpleAttribute::new));

    @Override
    public String getAttributeType() {
        return this.attribute;
    }

    @Override
    public Matchable getPredicate() {
        return Matchable.DEFAULT_TRUE;
    }

    @Override
    public NumericOperation getOperation() {
        return NumericOperation.ADDITION;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public float leveledValue() {
        return this.value;
    }

    @Override
    public Category getCategory() {
        return Category.UNDEFINED;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public List<String> targets() {
        return Collections.emptyList();
    }

    @Override
    public String targetType() {
        return null;
    }

    @Override
    public Context getContext() {
        return Contexts.UNDEFINED;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public String getId() {
        return String.format("%s-%s", this.attribute, Float.valueOf(this.value));
    }

    @Override
    public String type() {
        return this.getAttributeType();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attribute, Float.valueOf(this.value));
    }

    @Override
    public ComputedAttribute compute() {
        return ComputedAttribute.of(this.leveledValue(), this.type());
    }

    @Override
    public Function<Float, Float> getCalculation() {
        return value -> Float.valueOf(value.floatValue() + this.getValue());
    }

    @Override
    public String toString() {
        return "Attribute{attribute=" + this.attribute + ", value=" + this.value + "}";
    }
}

