/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2;

import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.CalculationOrder;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.attribute.AttributeBuilder;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.property.v2.PropertyProcessor;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class CompositePropertyProcessor
implements PropertyProcessor {
    @Override
    public List<Property> process(List<Property> propertyList, Matchable target, MatchContext context) {
        return this.combineCompositeProperties(propertyList, target, context);
    }

    private List<Property> combineCompositeProperties(List<Property> props, Matchable target, MatchContext context) {
        List<Property> compositeAttributes = Property.stream(props).getAttributes().filter(attribute -> attribute.getContext().test(Contexts.COMPOSITE)).filter(attribute -> attribute.applyCondition(target, context)).collect(Collectors.toList());
        ArrayList<Property> newValues = new ArrayList<Property>();
        Set types = compositeAttributes.stream().map(Property::type).collect(Collectors.toUnmodifiableSet());
        for (String type : types) {
            boolean onlyFromSameSource;
            List<Attribute> compAttributes = compositeAttributes.stream().filter(prop -> {
                Attribute attribute1;
                return prop instanceof Attribute && (attribute1 = (Attribute)prop).getAttributeType().equals(type);
            }).map(Attribute.class::cast).toList();
            boolean lessThanTwo = compAttributes.size() < 2;
            boolean bl = onlyFromSameSource = compAttributes.stream().map(Attribute::source).flatMap(Optional::stream).collect(Collectors.toUnmodifiableSet()).size() < 2;
            if (lessThanTwo || onlyFromSameSource) continue;
            AttributeBuilder newBaseAttribute = new AttributeBuilder(type).applyOperation(NumericOperation.ADDITION).applyOrder(CalculationOrder.BASE).applyContext(Contexts.UNDEFINED).applyCategory(Category.PASS);
            newBaseAttribute.applyValue(Property.stream(compositeAttributes, target, context).applyAttribute(type));
            Object combinedId = compositeAttributes.stream().filter(attr -> attr.type().equals(type)).map(Attribute.class::cast).map(Attribute::getId).reduce(Identifiers.EMPTY_IDENTIFIER, (x$0, xva$1) -> String.join(x$0, xva$1));
            combinedId = (String)combinedId + UUID.randomUUID();
            newBaseAttribute.applyId((String)combinedId);
            Attribute attribute2 = newBaseAttribute.build();
            if (attribute2.getValue() == 0.0f) continue;
            newValues.add(attribute2);
        }
        return newValues;
    }
}

