/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2;

import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import java.util.Objects;

public class ComputedAttributeBuilder {
    private PropertyContainer source = PropertyContainer.EMPTY;
    private MatchContext context = MatchContext.of();
    private String attributeKey;

    public ComputedAttributeBuilder(String attributeKey) {
        this.attributeKey = attributeKey;
    }

    public static ComputedAttributeBuilder of(String type) {
        return new ComputedAttributeBuilder(type);
    }

    public ComputedAttributeBuilder addSource(PropertyContainer container) {
        this.source = this.source.with(container);
        return this;
    }

    public ComputedAttributeBuilder addSource(Attribute attribute) {
        this.source = this.source.with(PropertyContainer.of(attribute));
        return this;
    }

    public ComputedAttributeBuilder context(MatchContext context) {
        this.context = context;
        return this;
    }

    public ComputedAttributeBuilder attribute(String attributeKey) {
        this.attributeKey = attributeKey;
        return this;
    }

    public ComputedAttribute build() {
        return ComputedAttribute.of(this.source, this.attributeKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputedAttributeBuilder that = (ComputedAttributeBuilder)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.context, that.context) && Objects.equals(this.attributeKey, that.attributeKey);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.context, this.attributeKey);
    }

    public PropertyContainer source() {
        return this.source;
    }

    public MatchContext context() {
        return this.context;
    }

    public String attributeKey() {
        return this.attributeKey;
    }

    public ComputedAttributeBuilder source(PropertyContainer source) {
        this.source = source;
        return this;
    }

    public ComputedAttributeBuilder attributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
        return this;
    }
}

