/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2;

import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.attribute.AttributeBuilder;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.property.v2.PropertyProcessor;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttackSpeed;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class UpgradePropertyProcessor
implements PropertyProcessor {
    private final Set<Category> categories;

    public UpgradePropertyProcessor(Set<Category> categories) {
        this.categories = categories;
    }

    @Override
    public List<Property> process(List<Property> propertyList, Matchable target, MatchContext context) {
        List<Property> otherProperties = propertyList.stream().filter(property -> !this.isAttribute((Property)property)).toList();
        List<Attribute> attributes = Property.stream(propertyList).getAttributes().filter(attribute -> this.filterAttribute((Attribute)attribute, target, context)).map(this::mapToUndefined).toList();
        return Stream.of(otherProperties, attributes).flatMap(Collection::stream).map(Property.class::cast).toList();
    }

    private boolean filterAttribute(Attribute attribute, Matchable target, MatchContext context) {
        if (!attribute.applyCondition(target, context)) {
            return false;
        }
        if (this.categories.contains((Object)Category.UNDEFINED) && this.isArrowFilteredAttribute(attribute.getAttributeType())) {
            return false;
        }
        if (attribute.getContext().test(Contexts.UNDEFINED) || attribute.getCategory() == Category.ALL || attribute.getCategory() == Category.PASS) {
            return true;
        }
        return this.categories.contains((Object)attribute.getCategory());
    }

    private boolean isArrowFilteredAttribute(String attributeType) {
        Set<String> filters = Set.of("WEIGHT", "DURABILITY", AttackSpeed.KEY, "ATTACK_DAMAGE");
        return filters.contains(attributeType);
    }

    private Attribute mapToUndefined(Attribute attribute) {
        return AttributeBuilder.createAttributeBuilderFromAttribute(attribute).applyCategory(Category.PASS).applyContext(Contexts.UNDEFINED).build();
    }

    private boolean isAttribute(Property property) {
        return property instanceof Attribute;
    }
}

