/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.attribute.attributes;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttackSpeed;
import com.sigmundgranaas.forgero.core.property.v2.cache.ContainerTargetPair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class AttributeHelper {
    private final PropertyContainer container;
    private final Map<String, BiFunction<ContainerTargetPair, String, ComputedAttribute>> map;

    public AttributeHelper(PropertyContainer container) {
        this.container = container;
        this.map = AttributeHelper.attributeStringMap();
    }

    public static Map<String, BiFunction<ContainerTargetPair, String, ComputedAttribute>> attributeStringMap() {
        HashMap<String, BiFunction<ContainerTargetPair, String, ComputedAttribute>> map = new HashMap<String, BiFunction<ContainerTargetPair, String, ComputedAttribute>>();
        map.put("ATTACK_DAMAGE", ComputedAttribute::of);
        map.put("DURABILITY", ComputedAttribute::of);
        map.put(AttackSpeed.KEY, ComputedAttribute::of);
        map.put("MINING_SPEED", ComputedAttribute::of);
        map.put("MINING_LEVEL", ComputedAttribute::of);
        map.put("WEIGHT", ComputedAttribute::of);
        return map;
    }

    private static BiFunction<ContainerTargetPair, String, ComputedAttribute> defaultAttributeFn(String type) {
        return (container, target) -> ComputedAttribute.of(container, type);
    }

    public ComputedAttribute apply(String type) {
        return this.map.getOrDefault(type, AttributeHelper.defaultAttributeFn(type)).apply(ContainerTargetPair.of(this.container), type);
    }

    public ComputedAttribute apply(ComputedAttribute type) {
        return this.apply(type.key());
    }
}

