/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.attribute.attributes;

import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttributeModification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AttributeModificationRegistry {
    private static final Map<String, List<AttributeModification>> MODIFICATIONS = new ConcurrentHashMap<String, List<AttributeModification>>();

    private AttributeModificationRegistry() {
    }

    public static ModificationBuilder modificationBuilder() {
        return new ModificationBuilder();
    }

    public static List<AttributeModification> getModifications(String attribute) {
        return MODIFICATIONS.getOrDefault(attribute, Collections.emptyList());
    }

    public static final class ModificationBuilder {
        private final List<AttributeModification> modifications = new ArrayList<AttributeModification>();
        private String attributeKey;

        private ModificationBuilder() {
        }

        public ModificationBuilder attributeKey(String attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        public ModificationBuilder modification(AttributeModification modification) {
            this.modifications.add(modification);
            return this;
        }

        public ModificationBuilder modifications(List<AttributeModification> mods) {
            this.modifications.addAll(mods);
            return this;
        }

        public void register() {
            if (this.attributeKey == null || this.modifications.isEmpty()) {
                throw new IllegalStateException("Attribute key and at least one modification must be set before registering");
            }
            MODIFICATIONS.merge(this.attributeKey, this.modifications, (existing, newMods) -> {
                existing.addAll(newMods);
                return existing;
            });
        }
    }
}

