/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.attribute.attributes;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttributeModification;
import com.sigmundgranaas.forgero.core.property.v2.cache.ContainerTargetPair;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.ArrayList;
import java.util.List;

public class ComputedAttribute
implements com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute {
    private final String key;
    private final PropertyContainer container;
    private final Matchable target;
    private final List<AttributeModification> modifications;
    private float value = 0.0f;

    public ComputedAttribute(String key, ContainerTargetPair pair) {
        this.key = key;
        this.container = pair.container();
        this.target = pair.target();
        this.modifications = new ArrayList<AttributeModification>();
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Float asFloat() {
        if (this.value == 0.0f) {
            float attributeValue = this.container.stream(this.target).applyAttribute(this.key());
            if (this.modifications.isEmpty()) {
                this.value = attributeValue;
                return Float.valueOf(attributeValue);
            }
            com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute computed = com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute.of(attributeValue, this.key());
            for (AttributeModification mod : this.modifications) {
                computed = (com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute)mod.apply(computed, this.container);
            }
            this.value = computed.asFloat().floatValue();
        }
        return Float.valueOf(this.value);
    }

    @Override
    public com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute modify(AttributeModification mod) {
        this.modifications.add(mod);
        return this;
    }
}

