/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class AttributeCache {
    public static final LoadingCache<AttributeContainerKey, ComputedAttribute> attributeCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.of(10L, ChronoUnit.SECONDS)).softValues().build((CacheLoader)new CacheLoader<AttributeContainerKey, ComputedAttribute>(){

        @NotNull
        public ComputedAttribute load(@NotNull AttributeContainerKey stack) {
            return ComputedAttribute.of(1.0f, "UNDEFINED");
        }
    });
    public static final LoadingCache<AttributeContainerKey, Boolean> containsAttributeCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).softValues().build((CacheLoader)new CacheLoader<AttributeContainerKey, Boolean>(){

        @NotNull
        public Boolean load(@NotNull AttributeContainerKey stack) {
            return stack.container().stream().getAttributes().anyMatch(attr -> attr.type().equals(stack.key()));
        }
    });

    public static Boolean has(AttributeContainerKey pair) {
        try {
            return (Boolean)containsAttributeCache.get((Object)pair);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ComputedAttribute computeIfAbsent(AttributeContainerKey key, Callable<ComputedAttribute> compute) {
        try {
            return (ComputedAttribute)attributeCache.get((Object)key, compute);
        }
        catch (Exception e) {
            return ComputedAttribute.of(1.0f, "UNDEFINED");
        }
    }

    public record AttributeContainerKey(PropertyContainer container, String key) {
        public static AttributeContainerKey of(PropertyContainer container, String key) {
            return new AttributeContainerKey(container, key);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.container, this.key);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeContainerKey that = (AttributeContainerKey)o;
            return Objects.equals(this.container, that.container) && Objects.equals(this.key, that.key);
        }

        @Override
        public String toString() {
            return String.format("%s-%s", this.container.hashCode(), this.key);
        }
    }
}

