/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sigmundgranaas.forgero.core.property.v2.RunnableHandler;
import com.sigmundgranaas.forgero.core.property.v2.cache.FeatureContainerKey;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class RunnableHandlerCache {
    public static final LoadingCache<FeatureContainerKey, RunnableHandler> runnableHandlerCache = CacheBuilder.newBuilder().maximumSize(600L).expireAfterAccess(Duration.of(5L, ChronoUnit.MINUTES)).build((CacheLoader)new CacheLoader<FeatureContainerKey, RunnableHandler>(){

        @NotNull
        public RunnableHandler load(@NotNull FeatureContainerKey key) {
            return RunnableHandler.EMPTY;
        }
    });

    public static RunnableHandler computeIfAbsent(FeatureContainerKey key, Callable<RunnableHandler> compute) {
        try {
            return (RunnableHandler)runnableHandlerCache.get((Object)key, compute);
        }
        catch (Exception e) {
            return RunnableHandler.EMPTY;
        }
    }
}

