/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.feature;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.model.match.PredicateFactory;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public record BasePredicateData(String id, String type, Matchable predicate, String title, List<String> description) {
    private static final Type typeOfList = new TypeToken<List<String>>(){}.getType();
    private static final Gson gson = new Gson();

    public static Optional<BasePredicateData> of(JsonElement element) {
        JsonObject object;
        if (element.isJsonObject() && (object = element.getAsJsonObject()).has("type")) {
            String type = object.get("type").getAsString();
            Matchable predicate = Matchable.DEFAULT_TRUE;
            if (object.has("predicate")) {
                predicate = new PredicateFactory().create(object.get("predicate"));
            }
            String id = Identifiers.EMPTY_IDENTIFIER;
            String title = Identifiers.EMPTY_IDENTIFIER;
            List<Object> description = Collections.emptyList();
            if (object.has("id")) {
                id = object.get("id").getAsString();
            }
            if (object.has("title")) {
                title = object.get("title").getAsString();
            }
            if (object.has("description")) {
                description = object.get("description").isJsonArray() ? (List<Object>)gson.fromJson((JsonElement)object.get("description").getAsJsonArray(), typeOfList) : List.of(object.get("description").getAsString());
            }
            return Optional.of(new BasePredicateData(id, type, predicate, title, description));
        }
        return Optional.empty();
    }
}

