/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.feature;

import com.google.gson.JsonElement;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateData;
import com.sigmundgranaas.forgero.core.property.v2.feature.Feature;
import java.util.Optional;
import java.util.function.BiFunction;

public interface FeatureBuilder<T extends Feature> {
    public static <T extends Feature> AbstractFeatureBuilder<T> of(String type, final BiFunction<BasePredicateData, JsonElement, T> baseBuilder) {
        return new AbstractFeatureBuilder<T>(type){

            @Override
            protected T buildFromBase(BasePredicateData data, JsonElement element) {
                return (Feature)baseBuilder.apply(data, element);
            }
        };
    }

    public Optional<T> build(JsonElement var1);

    public static abstract class AbstractFeatureBuilder<T extends Feature>
    implements FeatureBuilder<T> {
        private final String typeValue;

        protected AbstractFeatureBuilder(String typeValue) {
            this.typeValue = typeValue;
        }

        @Override
        public Optional<T> build(JsonElement element) {
            return BasePredicateData.of(element).filter(base -> base.type().equals(this.typeValue)).map(base -> this.buildFromBase((BasePredicateData)base, element));
        }

        protected abstract T buildFromBase(BasePredicateData var1, JsonElement var2);
    }
}

