/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateData;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.DefaultPredicateFeature;
import com.sigmundgranaas.forgero.core.property.v2.feature.Feature;
import com.sigmundgranaas.forgero.core.property.v2.feature.FeatureBuilder;
import com.sigmundgranaas.forgero.core.util.TypeToken;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FeatureRegistry {
    private static final Map<ClassKey<?>, FeatureBuilder<?>> builders = new HashMap();
    private static final Map<ClassKey<?>, Codec<?>> codecs = new HashMap();
    private static final Map<String, TypeToken<? extends Feature>> idMap = new HashMap<String, TypeToken<? extends Feature>>();

    public static <T extends Feature> Optional<T> of(ClassKey<T> key, JsonObject object) {
        return Optional.ofNullable(codecs.get(key)).flatMap(codec -> codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).map(key.clazz()::cast).result()).or(() -> Optional.ofNullable(builders.get(key)).flatMap(builder -> builder.build((JsonElement)object)).map(key.clazz()::cast));
    }

    public static Optional<Feature> of(JsonObject object) {
        if (object.has("type")) {
            String type = object.get("type").getAsString();
            Optional<TypeToken<? extends Feature>> clazz = Optional.ofNullable(idMap.get(type));
            if (clazz.isPresent()) {
                return clazz.map(zz -> new ClassKey(type, zz)).flatMap(key -> Optional.ofNullable(builders.get(key))).flatMap(builder -> builder.build((JsonElement)object)).map(clazz.get()::cast);
            }
            return BasePredicateData.of((JsonElement)object).map(DefaultPredicateFeature::new);
        }
        return Optional.empty();
    }

    public static <T extends Feature> void register(ClassKey<T> key, FeatureBuilder<T> builder) {
        idMap.put(key.type(), key.clazz());
        builders.put(key, builder);
    }

    public static <T extends Feature> void register(ClassKey<T> key, Codec<T> builder) {
        idMap.put(key.type(), key.clazz());
        codecs.put(key, builder);
    }
}

