/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.property.v2.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.handler.HandlerBuilderRegistry;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.core.util.TypeToken;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class HandlerBuilder {
    public static HandlerBuilder DEFAULT = new HandlerBuilder(new HandlerBuilderRegistry());
    private final HandlerBuilderRegistry registry;

    public HandlerBuilder(HandlerBuilderRegistry registry) {
        this.registry = registry;
    }

    public static <T> JsonBuilder<T> fromObjectOrStringDefaulted(final TypeToken<T> clazz, final String type, final Function<JsonObject, T> baseBuilder, final Supplier<T> defaultSupplier) {
        return new JsonBuilder<T>(){

            @Override
            public Optional<T> build(JsonElement element) {
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    return HandlerBuilder.fromStringOptional(type, defaultSupplier).apply(element.getAsString());
                }
                if (element.isJsonObject()) {
                    return Optional.of(baseBuilder.apply(element.getAsJsonObject()));
                }
                return Optional.empty();
            }

            @Override
            public TypeToken<T> getTargetClass() {
                return clazz;
            }
        };
    }

    public static <T> JsonBuilder<T> fromObject(TypeToken<T> clazz, Function<JsonObject, T> baseBuilder) {
        return HandlerBuilder.fromObjectOptional(clazz, object -> Optional.of(baseBuilder.apply((JsonObject)object)));
    }

    public static <T> JsonBuilder<T> fromObject(Class<T> clazz, Function<JsonObject, T> baseBuilder) {
        return HandlerBuilder.fromObjectOptional(TypeToken.of(clazz), object -> Optional.of(baseBuilder.apply((JsonObject)object)));
    }

    public static <T> JsonBuilder<T> fromString(final TypeToken<T> clazz, final Function<String, Optional<T>> baseBuilder) {
        return new JsonBuilder<T>(){

            @Override
            public Optional<T> build(JsonElement element) {
                return element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() ? (Optional)baseBuilder.apply(element.getAsString()) : Optional.empty();
            }

            @Override
            public TypeToken<T> getTargetClass() {
                return clazz;
            }
        };
    }

    public static <T> JsonBuilder<T> fromStringOrType(final TypeToken<T> clazz, final String type, final T instance) {
        return new JsonBuilder<T>(){

            @Override
            public Optional<T> build(JsonElement element) {
                if (element.isJsonPrimitive()) {
                    return Optional.ofNullable(element.getAsJsonPrimitive()).filter(JsonPrimitive::isString).map(JsonPrimitive::getAsString).filter(t -> t.equals(type)).map(it -> instance);
                }
                if (element.isJsonObject() && element.getAsJsonObject().has("type")) {
                    return Optional.ofNullable(element.getAsJsonObject().get("type")).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isString).map(JsonPrimitive::getAsString).filter(t -> t.equals(type)).map(it -> instance);
                }
                return Optional.empty();
            }

            @Override
            public TypeToken<T> getTargetClass() {
                return clazz;
            }
        };
    }

    public static <T> JsonBuilder<T> fromString(Class<T> clazz, Function<String, Optional<T>> baseBuilder) {
        return HandlerBuilder.fromString(TypeToken.of(clazz), baseBuilder);
    }

    public static <T> Function<String, Optional<T>> fromStringOptional(String type, Supplier<T> supplier) {
        return string -> string.equals(type) ? Optional.of(supplier.get()) : Optional.empty();
    }

    public static <T> JsonBuilder<T> fromObjectOptional(final TypeToken<T> clazz, final Function<JsonObject, Optional<T>> baseBuilder) {
        return new JsonBuilder<T>(){

            @Override
            public Optional<T> build(JsonElement element) {
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    return (Optional)baseBuilder.apply(object);
                }
                return Optional.empty();
            }

            @Override
            public TypeToken<T> getTargetClass() {
                return clazz;
            }
        };
    }

    public <T> Optional<T> build(ClassKey<T> key, JsonElement element) {
        Optional<T> result = this.buildInternal(key, element);
        if (result.isEmpty()) {
            Forgero.LOGGER.warn("Expected to be able to build element from: {} But found no corresponding registered handler. Maybe it is not set up to handle your json structure?", (Object)element.toString());
            Forgero.LOGGER.warn("Available handlers: {}", (Object)this.registry.entriesForKey(key).toString());
        }
        return result;
    }

    private <T> Optional<T> buildInternal(ClassKey<T> key, JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            if (object.has("type")) {
                String type = object.get("type").getAsString();
                return this.registry.get(key, type).flatMap(builder -> builder.build(element)).or(() -> this.registry.getCodec(key, type).flatMap(builder -> builder.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).map(key.clazz()::cast).result()));
            }
        } else {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                return this.registry.get(key, element.getAsString()).flatMap(builder -> builder.build(element));
            }
            if (element.isJsonArray()) {
                return this.registry.allJsonBuilders(key).stream().map(builder -> builder.build(element)).flatMap(Optional::stream).findFirst();
            }
        }
        return Optional.empty();
    }
}

