/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.registry;

import com.sigmundgranaas.forgero.core.registry.RankableConverter;
import java.util.function.Function;
import java.util.function.Predicate;

public class BuildableGenericConverter<T, R>
implements RankableConverter<T, R> {
    private Function<T, R> converter;
    private int priority;
    private Predicate<T> matcher;

    protected BuildableGenericConverter(int priority, Function<T, R> converter, Predicate<T> matcher) {
        this.priority = priority;
        this.converter = converter;
        this.matcher = matcher;
    }

    @Override
    public R convert(T entry) {
        return this.converter.apply(entry);
    }

    @Override
    public boolean matches(T entry) {
        return this.matcher.test(entry);
    }

    @Override
    public int priority() {
        return this.priority;
    }

    private static <T, R> int $default$priority() {
        return 0;
    }

    private static <T, R> Predicate<T> $default$matcher() {
        return state -> true;
    }

    protected BuildableGenericConverter(BuildableGenericConverterBuilder<T, R, ?, ?> b) {
        this.converter = b.converter;
        this.priority = b.priority$set ? b.priority$value : BuildableGenericConverter.$default$priority();
        this.matcher = b.matcher$set ? b.matcher$value : BuildableGenericConverter.$default$matcher();
    }

    public static <T, R> BuildableGenericConverterBuilder<T, R, ?, ?> builder() {
        return new BuildableGenericConverterBuilderImpl();
    }

    public static abstract class BuildableGenericConverterBuilder<T, R, C extends BuildableGenericConverter<T, R>, B extends BuildableGenericConverterBuilder<T, R, C, B>> {
        private Function<T, R> converter;
        private boolean priority$set;
        private int priority$value;
        private boolean matcher$set;
        private Predicate<T> matcher$value;

        public B converter(Function<T, R> converter) {
            this.converter = converter;
            return this.self();
        }

        public B priority(int priority) {
            this.priority$value = priority;
            this.priority$set = true;
            return this.self();
        }

        public B matcher(Predicate<T> matcher) {
            this.matcher$value = matcher;
            this.matcher$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "BuildableGenericConverter.BuildableGenericConverterBuilder(converter=" + this.converter + ", priority$value=" + this.priority$value + ", matcher$value=" + this.matcher$value + ")";
        }
    }

    private static final class BuildableGenericConverterBuilderImpl<T, R>
    extends BuildableGenericConverterBuilder<T, R, BuildableGenericConverter<T, R>, BuildableGenericConverterBuilderImpl<T, R>> {
        private BuildableGenericConverterBuilderImpl() {
        }

        @Override
        protected BuildableGenericConverterBuilderImpl<T, R> self() {
            return this;
        }

        @Override
        public BuildableGenericConverter<T, R> build() {
            return new BuildableGenericConverter(this);
        }
    }
}

