/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.registry;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class GenericRegistry<T> {
    private final Map<String, T> registry = new ConcurrentHashMap<String, T>();

    public synchronized RegisteredReference<T> register(String id, T item) {
        if (!this.registry.containsKey(id)) {
            RegisteredReference<T> reference = new RegisteredReference<T>(id, item);
            this.registry.put(id, item);
            return reference;
        }
        throw new IllegalStateException("Already registered entry with id: " + id);
    }

    public Optional<T> get(String id) {
        return Optional.ofNullable(this.registry.get(id));
    }

    public Collection<T> values() {
        return this.registry.values();
    }

    public ImmutableMap<String, T> references() {
        return ImmutableMap.copyOf(this.registry);
    }

    public Collection<T> entries() {
        return this.values();
    }

    public static final class RegisteredReference<T> {
        private final String id;
        private final T item;

        RegisteredReference(String id, T item) {
            this.id = id;
            this.item = item;
        }

        public String id() {
            return this.id;
        }

        public T item() {
            return this.item;
        }
    }
}

