/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.registry;

import com.sigmundgranaas.forgero.core.registry.GenericRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class LayeredRegistry<T> {
    private final Map<String, Map<String, T>> registry = new ConcurrentHashMap<String, Map<String, T>>();

    public synchronized GenericRegistry.RegisteredReference<T> register(String id, String group, T item) {
        if (!this.registry.containsKey(group)) {
            GenericRegistry.RegisteredReference<T> reference = new GenericRegistry.RegisteredReference<T>(id, item);
            this.registry.put(group, new ConcurrentHashMap());
            this.registry.get(group).put(id, item);
            return reference;
        }
        Map<String, T> groupMap = this.registry.get(group);
        if (!groupMap.containsKey(id)) {
            GenericRegistry.RegisteredReference<T> reference = new GenericRegistry.RegisteredReference<T>(id, item);
            groupMap.put(id, item);
            return reference;
        }
        throw new IllegalStateException("Already registered entry with id: " + id);
    }

    public Map<String, T> group(String group) {
        if (!this.registry.containsKey(group)) {
            throw new IllegalStateException("No group with name: " + group + ". You are referencing an invalid function.");
        }
        return this.registry.get(group);
    }

    public Optional<T> get(String id) {
        return this.registry.values().stream().flatMap(map -> map.entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals(id)).map(Map.Entry::getValue).findFirst();
    }

    public Collection<T> values() {
        return this.registry.values().stream().flatMap(map -> map.values().stream()).toList();
    }

    public Collection<T> entries() {
        return this.values();
    }
}

