/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.registry.impl;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.registry.IdentifiableRegistry;
import com.sigmundgranaas.forgero.core.registry.StateCollection;
import com.sigmundgranaas.forgero.core.state.MutableStateProvider;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.StateProvider;
import com.sigmundgranaas.forgero.core.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ReloadableStateRegistry
implements IdentifiableRegistry<State>,
StateCollection {
    private final Object $lock = new Object[0];
    private final Map<String, MutableStateProvider> stateMap = new ConcurrentHashMap<String, MutableStateProvider>();
    private final Map<String, List<StateProvider>> typeMap = new ConcurrentHashMap<String, List<StateProvider>>();

    @Override
    public Optional<StateProvider> find(String id) {
        Optional<StateProvider> optState = Optional.ofNullable((StateProvider)this.stateMap.get(id));
        if (optState.isEmpty()) {
            Forgero.LOGGER.debug("Tried to fetch {}, but it is not registered in the registry", (Object)id);
        }
        return optState;
    }

    @Override
    public ImmutableList<StateProvider> find(Type type) {
        return ImmutableList.builder().addAll((Iterable)this.typeMap.getOrDefault(type.typeName(), Collections.emptyList())).build();
    }

    @Override
    public ImmutableList<StateProvider> all() {
        return ImmutableList.builder().addAll(this.stateMap.values()).build();
    }

    @Override
    public boolean contains(String id) {
        return this.stateMap.containsKey(id);
    }

    @Override
    public ImmutableList<State> entries() {
        return ImmutableList.builder().addAll(this.stateMap.values().stream().map(Supplier::get).toList()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StateProvider register(State state) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.contains(state.identifier()) && !this.canReplaceEntries()) {
                org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[1];
                supplierArray[0] = state::identifier;
                Forgero.LOGGER.error("Attempted to override existing entry: {}, defaulting to original entry", supplierArray);
                return this.find(state.identifier()).orElse(() -> state);
            }
            MutableStateProvider provider = new MutableStateProvider(state);
            this.stateMap.put(state.identifier(), provider);
            this.registerType(state.type(), provider);
            return provider;
        }
    }

    private void registerType(Type type, MutableStateProvider supplier) {
        if (this.typeMap.containsKey(type.typeName())) {
            this.typeMap.get(type.typeName()).add(supplier);
        } else {
            this.typeMap.put(type.typeName(), new ArrayList<MutableStateProvider>(List.of(supplier)));
        }
        type.parent().forEach(parent -> this.registerType((Type)parent, supplier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<StateProvider> register(Collection<State> state) {
        Object object = this.$lock;
        synchronized (object) {
            return (Collection)state.stream().map(this::register).collect(ImmutableList.toImmutableList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Supplier<State> update(State state) {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.contains(state.identifier())) {
                org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[1];
                supplierArray[0] = state::identifier;
                Forgero.LOGGER.error("Attempted to update entry: {} which does not exists. Did you alter the config to create new states?", supplierArray);
                return () -> state;
            }
            MutableStateProvider provider = this.stateMap.get(state.identifier());
            provider.update(state);
            return provider;
        }
    }

    private boolean canReplaceEntries() {
        return false;
    }
}

