/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource;

import com.sigmundgranaas.forgero.core.configuration.ForgeroConfiguration;
import com.sigmundgranaas.forgero.core.resource.ResourceListener;
import com.sigmundgranaas.forgero.core.resource.ResourcePipeline;
import com.sigmundgranaas.forgero.core.resource.data.v2.DataOverrideSupplier;
import com.sigmundgranaas.forgero.core.resource.data.v2.DataPackage;
import com.sigmundgranaas.forgero.core.resource.data.v2.PackageSupplier;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.state.State;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class PipelineBuilder {
    private final List<DataPackage> packages = new ArrayList<DataPackage>();
    private final List<DataResource> overrides = new ArrayList<DataResource>();
    private final Set<String> dependencies = new HashSet<String>();
    private final List<ResourceListener<List<DataResource>>> dataListeners = new ArrayList<ResourceListener<List<DataResource>>>();
    private final List<ResourceListener<List<DataResource>>> inflatedDataListener = new ArrayList<ResourceListener<List<DataResource>>>();
    private final List<ResourceListener<Map<String, State>>> stateListener = new ArrayList<ResourceListener<Map<String, State>>>();
    private final List<ResourceListener<List<RecipeData>>> recipeListener = new ArrayList<ResourceListener<List<RecipeData>>>();
    private final List<ResourceListener<List<String>>> createStateListener = new ArrayList<ResourceListener<List<String>>>();
    private Supplier<ForgeroConfiguration> configProvider = ForgeroConfiguration::new;
    private boolean silent = false;

    public static PipelineBuilder builder() {
        return new PipelineBuilder();
    }

    public PipelineBuilder register(DataPackage dataPackage) {
        this.packages.add(dataPackage);
        return this;
    }

    public PipelineBuilder data(ResourceListener<List<DataResource>> listener) {
        this.dataListeners.add(listener);
        return this;
    }

    public PipelineBuilder inflated(ResourceListener<List<DataResource>> listener) {
        this.inflatedDataListener.add(listener);
        return this;
    }

    public PipelineBuilder state(ResourceListener<Map<String, State>> listener) {
        this.stateListener.add(listener);
        return this;
    }

    public PipelineBuilder recipes(ResourceListener<List<RecipeData>> listener) {
        this.recipeListener.add(listener);
        return this;
    }

    public PipelineBuilder createStates(ResourceListener<List<String>> listener) {
        this.createStateListener.add(listener);
        return this;
    }

    public PipelineBuilder register(PackageSupplier supplier) {
        List<DataPackage> packs = supplier.supply();
        this.packages.addAll(packs);
        return this;
    }

    public PipelineBuilder register(DataOverrideSupplier supplier) {
        List overrides = (List)supplier.get();
        this.overrides.addAll(overrides);
        return this;
    }

    public PipelineBuilder register(Supplier<ForgeroConfiguration> config) {
        this.configProvider = config;
        return this;
    }

    public PipelineBuilder register(Set<String> dependencies) {
        this.dependencies.addAll(dependencies);
        return this;
    }

    public PipelineBuilder silent() {
        this.silent = true;
        return this;
    }

    public ResourcePipeline build() {
        return new ResourcePipeline(this.packages, this.overrides, this.dataListeners, this.stateListener, this.inflatedDataListener, this.recipeListener, this.createStateListener, this.configProvider.get(), this.dependencies, this.silent);
    }
}

