/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource;

import com.google.common.collect.ImmutableSet;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfiguration;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.resource.ResourceListener;
import com.sigmundgranaas.forgero.core.resource.data.DataBuilder;
import com.sigmundgranaas.forgero.core.resource.data.StateConverter;
import com.sigmundgranaas.forgero.core.resource.data.v2.DataPackage;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DependencyData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.resource.data.v2.factory.TypeFactory;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.TypeTree;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourcePipeline {
    private final List<DataPackage> packages;
    private final List<DataResource> overrides;
    private final List<ResourceListener<List<DataResource>>> dataListeners;
    private final List<ResourceListener<List<DataResource>>> inflatedDataListener;
    private final List<ResourceListener<Map<String, State>>> stateListener;
    private final List<ResourceListener<List<RecipeData>>> recipeListener;
    private final List<ResourceListener<List<String>>> createStateListener;
    private final Set<String> dependencies;
    private final ForgeroConfiguration configuration;
    private final boolean silent;
    private List<String> createsStates;
    private Map<String, String> idMapper;
    private TypeTree tree;
    private List<RecipeData> recipes;

    public ResourcePipeline(List<DataPackage> packages, List<DataResource> overrides, List<ResourceListener<List<DataResource>>> dataListeners, List<ResourceListener<Map<String, State>>> stateListener, List<ResourceListener<List<DataResource>>> inflatedDataListener, List<ResourceListener<List<RecipeData>>> recipeListener, List<ResourceListener<List<String>>> createStateListener, ForgeroConfiguration configuration, Set<String> modDependencies, boolean silent) {
        this.packages = packages;
        this.overrides = overrides;
        this.dataListeners = dataListeners;
        this.inflatedDataListener = inflatedDataListener;
        this.stateListener = stateListener;
        this.recipeListener = recipeListener;
        this.createStateListener = createStateListener;
        this.tree = new TypeTree();
        this.idMapper = new HashMap<String, String>();
        this.recipes = new ArrayList<RecipeData>();
        this.dependencies = new HashSet<String>((Collection<String>)ImmutableSet.builder().add((Object[])new String[]{"forgero", "minecraft"}).addAll(modDependencies).build());
        this.configuration = configuration;
        this.silent = silent;
    }

    public static boolean filterDependencies(Set<String> availableDependencies, DependencyData dependencyData, String id, boolean silent, ForgeroConfiguration configuration) {
        boolean hasNoneOf;
        if (availableDependencies.isEmpty()) {
            return true;
        }
        boolean hasAllDependencies = availableDependencies.containsAll(dependencyData.getDependencies());
        boolean hasAnyOfDependencies = availableDependencies.stream().anyMatch(dependencyData.getAny_of()::contains) || dependencyData.getAny_of().isEmpty();
        boolean bl = hasNoneOf = availableDependencies.stream().noneMatch(dependencyData.getNone_of()::contains) || dependencyData.getNone_of().isEmpty();
        if (hasAllDependencies && hasAnyOfDependencies && hasNoneOf) {
            return true;
        }
        if (configuration.logDisabledPackages.booleanValue()) {
            if (!hasAllDependencies) {
                List<String> missingDependencies = dependencyData.getDependencies().stream().filter(depend -> !availableDependencies.contains(depend)).toList();
                if (!silent) {
                    Forgero.LOGGER.info("{} was disabled due to lacking dependencies: {}", (Object)id, missingDependencies);
                }
            } else if (!hasAnyOfDependencies) {
                if (!silent) {
                    Forgero.LOGGER.info("{} was disabled due to missing any of these dependencies: {}", (Object)id, dependencyData.getAny_of());
                }
            } else if (!silent) {
                Forgero.LOGGER.info("{} was disabled due to the presence of any of these dependencies: {}", (Object)id, dependencyData.getNone_of());
            }
        }
        return false;
    }

    public void execute() {
        List<DataPackage> validatedPackages = this.validatePackages(this.packages);
        List<DataResource> validatedResources = this.validateResources(validatedPackages);
        this.tree = this.assembleTypeTree(validatedResources);
        DataBuilder dataBuilder = DataBuilder.of(validatedResources, this.overrides, this.tree);
        List<DataResource> resources = dataBuilder.buildResources();
        this.recipes = dataBuilder.recipes();
        Map<String, State> states = this.mapStates(resources);
        this.recipeListener.forEach(listener -> listener.listen(this.recipes, this.tree, this.idMapper));
        this.dataListeners.forEach(listener -> listener.listen(validatedResources, this.tree, this.idMapper));
        this.inflatedDataListener.forEach(listener -> listener.listen(resources, this.tree, this.idMapper));
        this.stateListener.forEach(listener -> listener.listen(states, this.tree, this.idMapper));
        this.createStateListener.forEach(listener -> listener.listen(this.createsStates, this.tree, this.idMapper));
    }

    private Map<String, State> mapStates(List<DataResource> validatedResources) {
        StateConverter converter = new StateConverter(this.tree);
        validatedResources.forEach(converter::convert);
        this.idMapper = converter.nameMapper();
        this.createsStates = converter.createStates().stream().map(this.idMapper::get).distinct().toList();
        return converter.states();
    }

    private TypeTree assembleTypeTree(List<DataResource> resources) {
        TypeTree tree = new TypeTree();
        TypeFactory.convert(resources).forEach(tree::addNode);
        tree.resolve();
        return tree;
    }

    private List<DataPackage> validatePackages(List<DataPackage> packages) {
        this.dependencies.add("forgero");
        this.dependencies.add("minecraft");
        packages.forEach(pack -> this.dependencies.add(pack.name()));
        List<DataPackage> validatedResources = packages.stream().filter(this::filterPackages).toList();
        if (this.configuration.resourceLogging.booleanValue() && !this.silent) {
            Forgero.LOGGER.info("Registered and validated {} Forgero packages", (Object)validatedResources.size());
            Forgero.LOGGER.info("{}", validatedResources.stream().map(Identifiable::name).toList());
        }
        return validatedResources;
    }

    private boolean filterPackages(DataPackage dataPackage) {
        if (!this.filterPacks(dataPackage)) {
            return false;
        }
        return ResourcePipeline.filterDependencies(this.dependencies, dataPackage.dependencies(), dataPackage.identifier(), this.silent, this.configuration);
    }

    private List<DataResource> validateResources(List<DataPackage> resources) {
        return resources.parallelStream().map(DataPackage::loadData).flatMap(Collection::stream).filter(this::filterResources).toList();
    }

    private boolean filterResources(DataResource resource) {
        boolean filter = ForgeroConfigurationLoader.configuration.disabledResources.stream().noneMatch(disabled -> resource.identifier().equals(disabled));
        if (!filter && ForgeroConfigurationLoader.configuration.resourceLogging.booleanValue() && !this.silent) {
            Forgero.LOGGER.info(MessageFormat.format("{0} was disabled by the configuration, located at {1}", resource.identifier(), ForgeroConfigurationLoader.configurationFilePath));
        }
        if (!filter) {
            return false;
        }
        return ResourcePipeline.filterDependencies(this.dependencies, resource.dependencies(), resource.identifier(), this.silent, this.configuration);
    }

    private boolean filterPacks(DataPackage dataPackage) {
        boolean filter = ForgeroConfigurationLoader.configuration.disabledPacks.stream().noneMatch(disabled -> dataPackage.identifier().equals(disabled));
        if (!filter && ForgeroConfigurationLoader.configuration.resourceLogging.booleanValue() && !this.silent) {
            Forgero.LOGGER.info(MessageFormat.format("{0} was disabled by the configuration, located at {1}", dataPackage.identifier(), ForgeroConfigurationLoader.configurationFilePath));
        }
        return filter;
    }
}

