/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.resource.data.processor.RecipeInflater;
import com.sigmundgranaas.forgero.core.resource.data.processor.SchematicConstructInflater;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ConstructData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ResourceType;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.type.TypeTree;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DataBuilder {
    private final Map<String, DataResource> resolvedResources;
    private final List<DataResource> finalResources;
    private final Map<String, DataResource> templates;
    private final TypeTree tree;
    private Set<String> typeDependencySet = new HashSet<String>();
    private List<DataResource> resources;
    private List<DataResource> overrides;
    private Map<String, List<DataResource>> mappedOverrides = new HashMap<String, List<DataResource>>();
    private List<RecipeData> recipes;
    private List<DataResource> unresolvedConstructs;

    public DataBuilder(List<DataResource> resources, List<DataResource> overrides, TypeTree tree) {
        this.resources = resources;
        this.overrides = overrides;
        this.resolvedResources = new HashMap<String, DataResource>();
        this.templates = new HashMap<String, DataResource>();
        this.unresolvedConstructs = new ArrayList<DataResource>();
        this.finalResources = new ArrayList<DataResource>();
        this.recipes = new ArrayList<RecipeData>();
        this.tree = tree;
    }

    public static DataBuilder of(List<DataResource> resources, List<DataResource> overrides, TypeTree tree) {
        return new DataBuilder(resources, overrides, tree);
    }

    public List<DataResource> buildResources() {
        this.mappedOverrides = this.mapOverrides(this.overrides);
        this.mapParentResources();
        this.assembleStandaloneResources();
        this.assembleConstructs();
        return this.finalResources;
    }

    private Map<String, List<DataResource>> mapOverrides(List<DataResource> overrides) {
        Map<String, List<DataResource>> result = overrides.stream().filter(this::validateOverrides).collect(Collectors.groupingBy(Identifiable::identifier));
        if (!result.isEmpty()) {
            Forgero.LOGGER.info("Validated overrides for {} resources", (Object)result.size());
        }
        return result;
    }

    public List<RecipeData> recipes() {
        return this.recipes;
    }

    private void mapParentResources() {
        Map<String, DataResource> namedResources = this.resources.stream().map(res -> this.applyOverride(this.mappedOverrides, (DataResource)res)).collect(Collectors.toMap(DataResource::name, dataResource -> dataResource, (present, newRes) -> newRes));
        namedResources.remove(Identifiers.EMPTY_IDENTIFIER);
        this.resources = namedResources.values().stream().map(res -> this.applyParent(namedResources, (DataResource)res)).filter(this::notAbstract).toList();
    }

    private DataResource applyParent(Map<String, DataResource> resources, DataResource resource) {
        if (this.hasParent(resource)) {
            Optional<DataResource> parent = Optional.ofNullable(resources.get(resource.parent()));
            if (parent.isPresent()) {
                return resource.mergeResource(this.applyParent(resources, parent.get()));
            }
            return resource;
        }
        return resource;
    }

    private DataResource applyOverride(Map<String, List<DataResource>> mappedOverrides, DataResource resource) {
        if (mappedOverrides.containsKey(resource.identifier())) {
            return mappedOverrides.get(resource.identifier()).stream().sorted(Comparator.comparingInt(DataResource::priority).reversed()).reduce(DataResource::mergeResource).map(resource::mergeResource).orElse(resource);
        }
        return resource;
    }

    private boolean validateOverrides(DataResource resource) {
        if (resource.priority() < 1) {
            Forgero.LOGGER.warn("0 is the default priority for resources, please set it higher for overrides. Current priority: {}", (Object)resource.priority());
            this.logResourceDataForDebug(resource);
            return false;
        }
        if (resource.construct().isPresent()) {
            Forgero.LOGGER.warn("Overrides cannot contain constructs");
            this.logResourceDataForDebug(resource);
            return false;
        }
        if (resource.name().equals(Identifiers.EMPTY_IDENTIFIER)) {
            Forgero.LOGGER.warn("Invalid name in override: {}", (Object)resource.identifier());
            this.logResourceDataForDebug(resource);
            return false;
        }
        if (resource.nameSpace().equals(Identifiers.EMPTY_IDENTIFIER)) {
            Forgero.LOGGER.warn("Invalid namespace in override: {}", (Object)resource.identifier());
            this.logResourceDataForDebug(resource);
            return false;
        }
        if (resource.properties().isEmpty()) {
            Forgero.LOGGER.warn("Empty properties in override: {}", (Object)resource.identifier());
            this.logResourceDataForDebug(resource);
            return false;
        }
        return true;
    }

    private void logResourceDataForDebug(DataResource resource) {
        Forgero.LOGGER.debug("Debug data for resource file:");
        Forgero.LOGGER.debug("Resource: {}", (Object)resource.identifier());
        Forgero.LOGGER.debug("Name: {}", (Object)resource.name());
        Forgero.LOGGER.debug("Namespace: {}", (Object)resource.nameSpace());
        Forgero.LOGGER.debug("Properties: {}", resource.properties());
    }

    private void assembleConstructs() {
        this.resources().stream().filter(this::isConstruct).forEach(this.unresolvedConstructs::add);
        this.resources().stream().filter(this::isTemplate).forEach(res -> this.templates.put(res.identifier(), (DataResource)res));
        boolean remainingResources = true;
        while (remainingResources) {
            this.unresolvedConstructs.stream().map(DataResource::construct).flatMap(Optional::stream).map(ConstructData::type).forEach(this.typeDependencySet::add);
            List temporaryResolved = this.unresolvedConstructs.stream().filter(this::hasValidComponents).map(this::mapConstructTemplate).flatMap(Collection::stream).toList();
            for (DataResource resource : temporaryResolved) {
                this.unresolvedConstructs = this.unresolvedConstructs.stream().filter(res -> !res.identifier().equals(resource.identifier())).collect(Collectors.toList());
                if (resource.resourceType() == ResourceType.CONSTRUCT_TEMPLATE) continue;
                this.addResource(resource);
            }
            int resolvedResources = temporaryResolved.size();
            if (resolvedResources == 0) {
                remainingResources = false;
            }
            this.typeDependencySet.clear();
        }
    }

    private List<DataResource> mapConstructTemplate(DataResource resource) {
        ArrayList<DataResource> resources = new ArrayList<DataResource>();
        if (resource.construct().isEmpty()) {
            return Collections.emptyList();
        }
        ConstructData construct = resource.construct().get();
        if (construct.target().equals(Identifiers.THIS_IDENTIFIER)) {
            return List.of(resource);
        }
        if (construct.target().equals(Identifiers.CREATE_IDENTIFIER)) {
            List<DataResource> constructs = this.mapConstructData(resource);
            resources.add(resource.toBuilder().construct(null).build());
            resources.addAll(constructs);
        }
        return resources;
    }

    private List<DataResource> mapConstructData(DataResource data) {
        Function<String, Optional<DataResource>> idFinder = id -> Optional.ofNullable(this.resolvedResources.get(id));
        Function<String, Optional<DataResource>> templateFinder = id -> Optional.ofNullable(this.templates.get(id));
        if (data.construct().isPresent() && data.construct().get().recipes().isPresent()) {
            List<RecipeData> inflatedRecipes = new RecipeInflater(data, this::findResourceFromType, idFinder, templateFinder).process();
            this.recipes.addAll(inflatedRecipes);
        }
        if (data.construct().isEmpty()) {
            return Collections.emptyList();
        }
        SchematicConstructInflater inflater = new SchematicConstructInflater(data, this::findResourceFromType, idFinder, templateFinder);
        return inflater.process();
    }

    private List<DataResource> findResourceFromType(String type) {
        return (List)this.tree.find(type).map(node -> node.getResources(DataResource.class)).orElse(ImmutableList.builder().build());
    }

    private boolean hasValidComponents(DataResource resource) {
        if (resource.construct().isEmpty()) {
            return false;
        }
        ConstructData construct = resource.construct().get();
        Iterator<IngredientData> iterator = construct.components().iterator();
        if (iterator.hasNext()) {
            IngredientData data = iterator.next();
            if (!data.type().equals(Identifiers.EMPTY_IDENTIFIER) && this.typeDependencySet.contains(data.type())) {
                return false;
            }
            if (!(!data.id().equals(Identifiers.EMPTY_IDENTIFIER) && this.resolvedResources.containsKey(data.id()) || data.id().equals(Identifiers.THIS_IDENTIFIER) || !data.type().equals(Identifiers.EMPTY_IDENTIFIER) && this.treeContainsTag(data.type()))) {
                return false;
            }
        }
        return true;
    }

    private boolean notAbstract(DataResource resource) {
        return resource.resourceType() != ResourceType.ABSTRACT;
    }

    private boolean hasDefaults(ConstructData data) {
        return data.components().stream().allMatch(ingredient -> {
            if (ingredient.id().equals(Identifiers.EMPTY_IDENTIFIER)) {
                return false;
            }
            if (ingredient.id().equals("handle_schematic")) {
                return true;
            }
            Optional<DataResource> res = Optional.ofNullable(this.resolvedResources.get(ingredient.id()));
            return res.filter(resource -> resource.resourceType() == ResourceType.DEFAULT).isPresent();
        });
    }

    private boolean hasParent(DataResource data) {
        return !data.parent().equals(Identifiers.EMPTY_IDENTIFIER) && !data.name().equals(Identifiers.EMPTY_IDENTIFIER) && this.isStatefulResource(data);
    }

    private boolean treeContainsTag(String tag) {
        return this.tree.find(tag).map(node -> !node.getResources(DataResource.class).isEmpty()).orElse(false);
    }

    private ImmutableList<DataResource> resourcesFromTag(String tag) {
        return this.tree.find(tag).map(node -> node.getResources(DataResource.class)).orElse(ImmutableList.builder().build());
    }

    private void assembleStandaloneResources() {
        this.resources().stream().filter(this::isIndependentResource).forEach(this::addResource);
    }

    private List<DataResource> resources() {
        return this.resources;
    }

    private String idToNameSpace(String id) {
        return id.split("#")[0];
    }

    private void addResource(DataResource resource) {
        this.resolvedResources.put(resource.identifier(), resource);
        this.finalResources.add(resource);
        this.tree.find(resource.type()).ifPresent(node -> node.addResource(resource, DataResource.class));
    }

    private boolean isIndependentResource(DataResource resource) {
        return resource.construct().isEmpty() && this.isStatefulResource(resource) && resource.properties().isPresent();
    }

    private boolean isConstruct(DataResource resource) {
        return resource.construct().isPresent() && this.isStatefulResource(resource);
    }

    private boolean isTemplate(DataResource resource) {
        return resource.resourceType() == ResourceType.CONSTRUCT_TEMPLATE;
    }

    private boolean isStatefulResource(DataResource resource) {
        if (resource.resourceType() == ResourceType.PACKAGE) {
            return false;
        }
        if (resource.resourceType() == ResourceType.TYPE_DEFINITION) {
            return false;
        }
        return !resource.name().equals(Identifiers.EMPTY_IDENTIFIER);
    }
}

