/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.sigmundgranaas.forgero.core.context.Context;
import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.property.CalculationOrder;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PropertyPojo {
    @SerializedName(value="features")
    public List<JsonObject> features;
    @SerializedName(value="attributes")
    private List<Attribute> attributes;
    @SerializedName(value="grouped_attributes")
    private List<Attribute> groupedAttributes;

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.addAll(Objects.requireNonNullElse(this.attributes, Collections.emptyList()));
        list.addAll(Objects.requireNonNullElse(this.groupedAttributes, Collections.emptyList()));
        return list;
    }

    public void setAttributes(List<Attribute> attributes) {
        ArrayList<Attribute> newList = new ArrayList<Attribute>(attributes);
        this.attributes = newList;
        this.groupedAttributes = Collections.emptyList();
    }

    public static class Attribute {
        public int priority = 0;
        public String id = Identifiers.EMPTY_IDENTIFIER;
        public String type;
        public CalculationOrder order = CalculationOrder.BASE;
        public NumericOperation operation = NumericOperation.ADDITION;
        public float value;
        public JsonElement predicate;
        public Category category = Category.UNDEFINED;
        public Context context = Contexts.UNDEFINED;
        public float max;
        public float min;

        public String toString() {
            return "Attribute{priority=" + this.priority + ", id='" + this.id + "', type='" + this.type + "', order=" + this.order + ", operation=" + this.operation + ", value=" + this.value + ", predicate=" + this.predicate + ", category=" + this.category + ", context=" + this.context + "}";
        }
    }
}

