/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.resource.data.DataConverter;
import com.sigmundgranaas.forgero.core.resource.data.factory.PropertyBuilder;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ConstructData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.state.LeveledState;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.Construct;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedSchematicPart;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedTool;
import com.sigmundgranaas.forgero.core.state.composite.StaticComposite;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.EmptySlot;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.core.type.MutableTypeNode;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.type.TypeTree;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StateConverter
implements DataConverter<State> {
    private final HashMap<String, State> states = new HashMap();
    private final TypeTree tree;
    private final HashMap<String, String> nameMapping = new HashMap();
    private final List<String> createStates = new ArrayList<String>();

    public StateConverter(TypeTree tree) {
        this.tree = tree;
    }

    @Override
    public Optional<State> convert(DataResource resource) {
        if (resource.container().isPresent() && resource.container().get().getType().equals(Identifiers.CREATE_IDENTIFIER)) {
            this.createStates.add(resource.identifier());
        }
        if (resource.type().equals("GEM")) {
            return this.createGem(resource);
        }
        if (resource.construct().isEmpty()) {
            return this.createState(resource);
        }
        return this.createComposite(resource);
    }

    public HashMap<String, State> states() {
        return this.states;
    }

    public HashMap<String, String> nameMapper() {
        return this.nameMapping;
    }

    public List<String> createStates() {
        return this.createStates;
    }

    private Optional<State> createComposite(DataResource resource) {
        if (resource.construct().isPresent()) {
            State state = resource.construct().get().components().size() > 0 ? this.buildTool(resource).or(() -> this.buildSchematicPart(resource)).orElseGet(() -> this.buildConstruct(resource)) : this.buildStaticComposite(resource);
            this.states.put(state.identifier(), state);
            this.nameMapping.put(resource.identifier(), state.identifier());
            return Optional.of(state);
        }
        return Optional.empty();
    }

    private State buildConstruct(DataResource resource) {
        Construct.ConstructBuilder builder = Construct.builder(SlotContainer.of(this.createSlots(resource.construct().get())));
        builder.type(this.tree.type(resource.type()));
        builder.nameSpace(resource.nameSpace());
        List<State> ingredients = resource.construct().map(ConstructData::components).orElse(Collections.emptyList()).stream().map(IngredientData::id).map(this.nameMapping::get).map(this.states::get).filter(Objects::nonNull).toList();
        ingredients.forEach(builder::addIngredient);
        return builder.build();
    }

    private Optional<State> buildTool(DataResource resource) {
        List<State> parts = resource.construct().map(ConstructData::components).orElse(Collections.emptyList()).stream().map(IngredientData::id).map(this.nameMapping::get).map(this.states::get).filter(Objects::nonNull).toList();
        Optional<ConstructedTool.ToolBuilder> builderOpt = ConstructedTool.ToolBuilder.builder(parts);
        if (builderOpt.isPresent()) {
            ConstructedTool.ToolBuilder builder = builderOpt.get();
            SlotContainer slotContainer = new SlotContainer(this.createSlots(resource.construct().get()));
            ((ConstructedTool.ToolBuilder)((ConstructedTool.ToolBuilder)builder.addSlotContainer(slotContainer)).type(this.tree.type(resource.type()))).nameSpace(resource.nameSpace());
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    private Optional<State> buildSchematicPart(DataResource resource) {
        if (resource.type().equals("ARROW") || resource.type().equals("BOW")) {
            return Optional.empty();
        }
        List<State> parts = resource.construct().map(ConstructData::components).orElse(Collections.emptyList()).stream().map(IngredientData::id).map(this.nameMapping::get).map(this.states::get).filter(Objects::nonNull).toList();
        Optional<ConstructedSchematicPart.SchematicPartBuilder> builderOpt = ConstructedSchematicPart.SchematicPartBuilder.builder(parts);
        if (builderOpt.isPresent()) {
            ConstructedSchematicPart.SchematicPartBuilder builder = builderOpt.get();
            SlotContainer slotContainer = new SlotContainer(this.createSlots(resource.construct().get()));
            ((ConstructedSchematicPart.SchematicPartBuilder)((ConstructedSchematicPart.SchematicPartBuilder)builder.addSlotContainer(slotContainer)).type(this.tree.type(resource.type()))).nameSpace(resource.nameSpace());
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    private State buildStaticComposite(DataResource resource) {
        String namespace = resource.nameSpace();
        String name = resource.name();
        Type type = this.tree.type(resource.type());
        PropertyContainer properties = resource.properties().map(PropertyBuilder::createPropertyListFromPOJO).map(PropertyContainer::of).orElse(PropertyContainer.of(Collections.emptyList()));
        SlotContainer slotContainer = new SlotContainer(resource.construct().map(this::createSlots).orElse(new ArrayList()));
        return new StaticComposite(slotContainer, name, namespace, type, properties);
    }

    private List<Slot> createSlots(ConstructData data) {
        return IntStream.range(0, data.slots().size()).mapToObj(index -> new EmptySlot(index, this.tree.find(data.slots().get(index).type()).map(MutableTypeNode::type).orElse(Type.of(data.slots().get(index).type())), data.slots().get(index).description(), Set.copyOf(data.slots().get(index).category()))).collect(Collectors.toList());
    }

    private Optional<State> createState(DataResource resource) {
        State state = State.of(resource.name(), resource.nameSpace(), this.tree.type(resource.type()), resource.properties().map(PropertyBuilder::createPropertyListFromPOJO).orElse(Collections.emptyList()), resource.getCustomData());
        this.states.put(state.identifier(), state);
        this.nameMapping.put(resource.identifier(), state.identifier());
        return Optional.of(state);
    }

    private Optional<State> createGem(DataResource resource) {
        LeveledState gem = LeveledState.builder().name(resource.name()).nameSpace(resource.nameSpace()).level(1).type(this.tree.type(resource.type())).properties(resource.properties().map(PropertyBuilder::createPropertyListFromPOJO).orElse(Collections.emptyList())).build();
        this.states.put(gem.identifier(), gem);
        this.nameMapping.put(resource.identifier(), gem.identifier());
        return Optional.of(gem);
    }
}

