/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.processor;

import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IngredientInflater {
    private final int entrySize;
    private final List<IngredientData> ingredients;

    public IngredientInflater(int entrySize, List<IngredientData> ingredients) {
        this.entrySize = entrySize;
        this.ingredients = ingredients;
    }

    public IngredientInflater addIngredient(int index, IngredientData data) {
        this.ingredients.add(index, data);
        return this;
    }

    public IngredientInflater copy() {
        return new IngredientInflater(this.entrySize, new ArrayList<IngredientData>(this.ingredients));
    }

    public boolean hasEmptyIngredientSlots() {
        return this.ingredients.size() != this.entrySize;
    }

    public List<IngredientInflater> addEntries(int index, List<IngredientData> data) {
        return data.stream().map(entry -> this.copy().addIngredient(index, (IngredientData)entry)).toList();
    }

    public List<IngredientData> getIngredients() {
        return this.ingredients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngredientInflater that = (IngredientInflater)o;
        if (this.entrySize == that.entrySize) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (that.ingredients.get(i) == this.ingredients.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.entrySize, this.ingredients);
    }
}

