/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.processor;

import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.resource.data.processor.IngredientCollection;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ConstructData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ResourceType;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RecipeInflater {
    private final DataResource resource;
    private final Function<String, List<DataResource>> typeFinder;

    public RecipeInflater(DataResource resource, Function<String, List<DataResource>> typeFinder, Function<String, Optional<DataResource>> idFinder, Function<String, Optional<DataResource>> templateProvider) {
        this.resource = resource;
        this.typeFinder = typeFinder;
    }

    public List<RecipeData> process() {
        if (this.invalidData()) {
            return Collections.emptyList();
        }
        return this.resource.construct().flatMap(ConstructData::recipes).orElse(Collections.emptyList()).stream().map(this::inflateIngredients).flatMap(Collection::stream).toList();
    }

    private List<RecipeData> inflateIngredients(RecipeData recipe) {
        ArrayList<List<IngredientData>> templateIngredients = new ArrayList<List<IngredientData>>();
        for (IngredientData ingredient : recipe.ingredients()) {
            if (ingredient.id().equals(Identifiers.THIS_IDENTIFIER)) {
                templateIngredients.add(List.of(IngredientData.builder().id(this.resource.identifier()).unique(true).build()));
                continue;
            }
            if (ingredient.type().equals(Identifiers.EMPTY_IDENTIFIER)) continue;
            if (ingredient.unique()) {
                templateIngredients.add(this.findUniqueIngredients(ingredient));
                continue;
            }
            templateIngredients.add(List.of(ingredient));
        }
        IngredientCollection collection = new IngredientCollection(templateIngredients.size());
        for (int i = 0; i < templateIngredients.size(); ++i) {
            collection.addEntries(i, (List)templateIngredients.get(i));
        }
        List<RecipeData> ingredients = collection.getCollection().stream().map(inflater -> recipe.toBuilder().ingredients(inflater.getIngredients()).build()).toList();
        return this.buildRecipes(ingredients, recipe);
    }

    private List<RecipeData> buildRecipes(List<RecipeData> inflatedIngredients, RecipeData originalRecipe) {
        ArrayList<RecipeData> recipes = new ArrayList<RecipeData>();
        for (RecipeData inflatedIngredient : inflatedIngredients) {
            List<IngredientData> newComponents = inflatedIngredient.ingredients();
            String name = String.join((CharSequence)Common.ELEMENT_SEPARATOR, newComponents.stream().map(this::ingredientToName).toList());
            recipes.add(RecipeData.builder().ingredients(newComponents).craftingType(originalRecipe.type()).target(this.resource.nameSpace() + ":" + name).count(originalRecipe.count()).build());
        }
        return recipes;
    }

    private String idToName(String id) {
        String[] split = id.split(":");
        if (split.length > 1) {
            return split[1];
        }
        return id;
    }

    private String ingredientToName(IngredientData data) {
        if (data.id().equals(Identifiers.EMPTY_IDENTIFIER)) {
            return this.typeFinder.apply(data.type()).stream().filter(res -> res.resourceType() == ResourceType.DEFAULT).findFirst().map(DataResource::name).orElse(data.type().toLowerCase(Locale.ENGLISH));
        }
        return this.idToName(data.id());
    }

    private boolean isTyped(IngredientData data) {
        return !data.type().equals(Identifiers.EMPTY_IDENTIFIER);
    }

    private boolean isId(IngredientData data) {
        return !data.id().equals(Identifiers.EMPTY_IDENTIFIER);
    }

    private boolean isThis(IngredientData data) {
        return this.isId(data) && data.id().equals(Identifiers.THIS_IDENTIFIER);
    }

    private boolean invalidData() {
        return this.resource.construct().isEmpty();
    }

    private List<IngredientData> findUniqueIngredients(IngredientData data) {
        return this.typeFinder.apply(data.type()).stream().map(res -> IngredientData.builder().id(res.identifier()).amount(data.amount()).unique(true).build()).toList();
    }

    public Set<String> dependencies() {
        return this.resource.construct().flatMap(ConstructData::recipes).orElse(Collections.emptyList()).stream().map(RecipeData::ingredients).flatMap(Collection::stream).map(ingredient -> ingredient.id().equals(Identifiers.EMPTY_IDENTIFIER) ? ingredient.id() : ingredient.type()).collect(Collectors.toSet());
    }
}

